/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.qr.scheme;

import org.tio.utils.qr.scheme.Schema;

public class GooglePlay
extends Schema {
    public static final String GPLAY = "{{{market://details?id=%s}}}";
    private String appPackage;

    public String getAppPackage() {
        return this.appPackage;
    }

    public void setAppPackage(String appPackage) {
        this.appPackage = appPackage;
    }

    @Override
    public Schema parseSchema(String code) {
        if (code == null || !code.trim().toLowerCase().startsWith("{{{market:")) {
            throw new IllegalArgumentException("this is not a google play code: " + code);
        }
        String[] paths = code.trim().toLowerCase().replace("}}}", "").split("=");
        if (paths != null && paths.length > 1) {
            this.setAppPackage(paths[1]);
        }
        return this;
    }

    @Override
    public String generateString() {
        return String.format(GPLAY, this.appPackage != null ? this.appPackage : "");
    }

    public String toString() {
        return this.generateString();
    }

    public static GooglePlay parse(String code) {
        GooglePlay googlePlay = new GooglePlay();
        googlePlay.parseSchema(code);
        return googlePlay;
    }
}

