/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.server;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.Aio;
import org.tio.core.ChannelContext;
import org.tio.core.GroupContext;
import org.tio.core.exception.AioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.http.common.HttpConst;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpRequestDecoder;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.HttpResponseEncoder;
import org.tio.http.common.HttpResponseStatus;
import org.tio.server.intf.ServerAioHandler;
import org.tio.websocket.common.Opcode;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;
import org.tio.websocket.common.WsServerDecoder;
import org.tio.websocket.common.WsServerEncoder;
import org.tio.websocket.common.WsSessionContext;
import org.tio.websocket.common.util.BASE64Util;
import org.tio.websocket.common.util.SHA1Util;
import org.tio.websocket.server.WsServerConfig;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class WsServerAioHandler
implements ServerAioHandler {
    private static Logger log = LoggerFactory.getLogger(WsServerAioHandler.class);
    private WsServerConfig wsServerConfig;
    private IWsMsgHandler wsMsgHandler;

    public static void main(String[] args) {
    }

    public WsServerAioHandler(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler) {
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
    }

    public WsRequest decode(ByteBuffer buffer, ChannelContext channelContext) throws AioDecodeException {
        WsSessionContext wsSessionContext = (WsSessionContext)channelContext.getAttribute();
        if (!wsSessionContext.isHandshaked()) {
            HttpRequest request = HttpRequestDecoder.decode((ByteBuffer)buffer, (ChannelContext)channelContext);
            if (request == null) {
                return null;
            }
            HttpResponse httpResponse = WsServerAioHandler.updateWebSocketProtocol(request, channelContext);
            if (httpResponse == null) {
                throw new AioDecodeException("http\u534f\u8bae\u5347\u7ea7\u5230websocket\u534f\u8bae\u5931\u8d25");
            }
            wsSessionContext.setHandshakeRequestPacket(request);
            wsSessionContext.setHandshakeResponsePacket(httpResponse);
            WsRequest wsRequestPacket = new WsRequest();
            wsRequestPacket.setHandShake(true);
            return wsRequestPacket;
        }
        WsRequest websocketPacket = WsServerDecoder.decode((ByteBuffer)buffer, (ChannelContext)channelContext);
        return websocketPacket;
    }

    public ByteBuffer encode(Packet packet, GroupContext groupContext, ChannelContext channelContext) {
        WsResponse wsResponse = (WsResponse)packet;
        if (wsResponse.isHandShake()) {
            WsSessionContext imSessionContext = (WsSessionContext)channelContext.getAttribute();
            HttpResponse handshakeResponsePacket = imSessionContext.getHandshakeResponsePacket();
            return HttpResponseEncoder.encode((HttpResponse)handshakeResponsePacket, (GroupContext)groupContext, (ChannelContext)channelContext, (boolean)false);
        }
        ByteBuffer byteBuffer = WsServerEncoder.encode((WsResponse)wsResponse, (GroupContext)groupContext, (ChannelContext)channelContext);
        return byteBuffer;
    }

    public WsServerConfig getHttpConfig() {
        return this.wsServerConfig;
    }

    private WsResponse h(WsRequest websocketPacket, byte[] bytes, Opcode opcode, ChannelContext channelContext) throws Exception {
        WsResponse wsResponse = null;
        if (opcode == Opcode.TEXT) {
            if (bytes == null || bytes.length == 0) {
                Aio.remove((ChannelContext)channelContext, (String)"\u9519\u8bef\u7684websocket\u5305\uff0cbody\u4e3a\u7a7a");
                return null;
            }
            String text = new String(bytes, this.wsServerConfig.getCharset());
            Object retObj = this.wsMsgHandler.onText(websocketPacket, text, channelContext);
            String methodName = "onText";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.BINARY) {
            if (bytes == null || bytes.length == 0) {
                Aio.remove((ChannelContext)channelContext, (String)"\u9519\u8bef\u7684websocket\u5305\uff0cbody\u4e3a\u7a7a");
                return null;
            }
            Object retObj = this.wsMsgHandler.onBytes(websocketPacket, bytes, channelContext);
            String methodName = "onBytes";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        if (opcode == Opcode.PING || opcode == Opcode.PONG) {
            log.info("\u6536\u5230" + opcode);
            return null;
        }
        if (opcode == Opcode.CLOSE) {
            Object retObj = this.wsMsgHandler.onClose(websocketPacket, bytes, channelContext);
            String methodName = "onClose";
            wsResponse = this.processRetObj(retObj, methodName, channelContext);
            return wsResponse;
        }
        Aio.remove((ChannelContext)channelContext, (String)"\u9519\u8bef\u7684websocket\u5305\uff0c\u9519\u8bef\u7684Opcode");
        return null;
    }

    public void handler(Packet packet, ChannelContext channelContext) throws Exception {
        WsRequest wsRequest = (WsRequest)packet;
        if (wsRequest.isHandShake()) {
            HttpResponse httpResponse;
            WsSessionContext wsSessionContext = (WsSessionContext)channelContext.getAttribute();
            HttpRequest request = wsSessionContext.getHandshakeRequestPacket();
            HttpResponse r = this.wsMsgHandler.handshake(request, httpResponse = wsSessionContext.getHandshakeResponsePacket(), channelContext);
            if (r == null) {
                Aio.remove((ChannelContext)channelContext, (String)"\u4e1a\u52a1\u5c42\u4e0d\u540c\u610f\u63e1\u624b");
                return;
            }
            wsSessionContext.setHandshakeResponsePacket(r);
            WsResponse wsResponse = new WsResponse();
            wsResponse.setHandShake(true);
            Aio.send((ChannelContext)channelContext, (Packet)wsResponse);
            wsSessionContext.setHandshaked(true);
            return;
        }
        WsResponse wsResponse = this.h(wsRequest, wsRequest.getBody(), wsRequest.getWsOpcode(), channelContext);
        if (wsResponse != null) {
            Aio.send((ChannelContext)channelContext, (Packet)wsResponse);
        }
    }

    private WsResponse processRetObj(Object obj, String methodName, ChannelContext channelContext) throws Exception {
        WsResponse wsResponse = null;
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            String str = (String)obj;
            wsResponse = WsResponse.fromText((String)str, (String)this.wsServerConfig.getCharset());
            return wsResponse;
        }
        if (obj instanceof byte[]) {
            wsResponse = WsResponse.fromBytes((byte[])((byte[])obj));
            return wsResponse;
        }
        if (obj instanceof WsResponse) {
            return (WsResponse)obj;
        }
        if (obj instanceof ByteBuffer) {
            byte[] bs = ((ByteBuffer)obj).array();
            wsResponse = WsResponse.fromBytes((byte[])bs);
            return wsResponse;
        }
        log.error("{} {}.{}()\u65b9\u6cd5\uff0c\u53ea\u5141\u8bb8\u8fd4\u56debyte[]\u3001ByteBuffer\u3001WsResponse\u6216null\uff0c\u4f46\u662f\u7a0b\u5e8f\u8fd4\u56de\u4e86{}", new Object[]{channelContext, this.getClass().getName(), methodName, obj.getClass().getName()});
        return null;
    }

    public void setHttpConfig(WsServerConfig httpConfig) {
        this.wsServerConfig = httpConfig;
    }

    public static HttpResponse updateWebSocketProtocol(HttpRequest request, ChannelContext channelContext) {
        Map headers = request.getHeaders();
        String Sec_WebSocket_Key = (String)headers.get("sec-websocket-key");
        if (StringUtils.isNotBlank((CharSequence)Sec_WebSocket_Key)) {
            String Sec_WebSocket_Key_Magic = Sec_WebSocket_Key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11";
            byte[] key_array = SHA1Util.SHA1((String)Sec_WebSocket_Key_Magic);
            String acceptKey = BASE64Util.byteArrayToBase64((byte[])key_array);
            HttpResponse httpResponse = new HttpResponse(request);
            httpResponse.setStatus(HttpResponseStatus.C101);
            HashMap<String, String> respHeaders = new HashMap<String, String>();
            respHeaders.put(HttpConst.ResponseHeaderKey.Connection, HttpConst.ResponseHeaderValue.Connection.Upgrade);
            respHeaders.put(HttpConst.ResponseHeaderKey.Upgrade, "WebSocket");
            respHeaders.put(HttpConst.ResponseHeaderKey.Sec_WebSocket_Accept, acceptKey);
            httpResponse.setHeaders(respHeaders);
            return httpResponse;
        }
        return null;
    }
}

