/*
 * Decompiled with CFR 0.152.
 */
package org.tio.websocket.server;

import java.io.IOException;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.intf.TioUuid;
import org.tio.http.server.util.Threads;
import org.tio.server.AioServer;
import org.tio.server.ServerGroupContext;
import org.tio.server.intf.ServerAioHandler;
import org.tio.server.intf.ServerAioListener;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.websocket.common.WsTioUuid;
import org.tio.websocket.server.WsServerAioHandler;
import org.tio.websocket.server.WsServerAioListener;
import org.tio.websocket.server.WsServerConfig;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class WsServerStarter {
    private static Logger log = LoggerFactory.getLogger(WsServerStarter.class);
    private WsServerConfig wsServerConfig = null;
    private IWsMsgHandler wsMsgHandler = null;
    private WsServerAioHandler wsServerAioHandler = null;
    private WsServerAioListener wsServerAioListener = null;
    private ServerGroupContext serverGroupContext = null;
    private AioServer aioServer = null;

    public WsServerConfig getWsServerConfig() {
        return this.wsServerConfig;
    }

    public IWsMsgHandler getWsMsgHandler() {
        return this.wsMsgHandler;
    }

    public WsServerAioHandler getWsServerAioHandler() {
        return this.wsServerAioHandler;
    }

    public WsServerAioListener getWsServerAioListener() {
        return this.wsServerAioListener;
    }

    public ServerGroupContext getServerGroupContext() {
        return this.serverGroupContext;
    }

    public WsServerStarter(int port, IWsMsgHandler wsMsgHandler) throws IOException {
        this(port, wsMsgHandler, null, null);
    }

    public WsServerStarter(int port, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(new WsServerConfig(port), wsMsgHandler, tioExecutor, groupExecutor);
    }

    public WsServerStarter(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler) throws IOException {
        this(wsServerConfig, wsMsgHandler, null, null);
    }

    public WsServerStarter(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        this(wsServerConfig, wsMsgHandler, (TioUuid)new WsTioUuid(), tioExecutor, groupExecutor);
    }

    public WsServerStarter(WsServerConfig wsServerConfig, IWsMsgHandler wsMsgHandler, TioUuid tioUuid, SynThreadPoolExecutor tioExecutor, ThreadPoolExecutor groupExecutor) throws IOException {
        if (tioExecutor == null) {
            tioExecutor = Threads.tioExecutor;
        }
        if (groupExecutor == null) {
            groupExecutor = Threads.groupExecutor;
        }
        this.wsServerConfig = wsServerConfig;
        this.wsMsgHandler = wsMsgHandler;
        this.wsServerAioHandler = new WsServerAioHandler(wsServerConfig, wsMsgHandler);
        this.wsServerAioListener = new WsServerAioListener();
        this.serverGroupContext = new ServerGroupContext("Tio Websocket Server", (ServerAioHandler)this.wsServerAioHandler, (ServerAioListener)this.wsServerAioListener, tioExecutor, groupExecutor);
        this.serverGroupContext.setHeartbeatTimeout(0L);
        this.aioServer = new AioServer(this.serverGroupContext);
        this.serverGroupContext.setTioUuid(tioUuid);
    }

    public void start() throws IOException {
        this.aioServer.start(this.wsServerConfig.getBindIp(), this.wsServerConfig.getBindPort().intValue());
    }
}

