/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.processor;

import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.IProcessor;
import org.thymeleaf.processor.ProcessorMatchingContext;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProcessorAndContext
implements Comparable<ProcessorAndContext> {
    private final IProcessor processor;
    private final ProcessorMatchingContext context;

    public ProcessorAndContext(IProcessor processor, ProcessorMatchingContext context) {
        Validate.notNull(processor, "Processor cannot be null");
        Validate.notNull(context, "Context cannot be null");
        this.processor = processor;
        this.context = context;
    }

    public IProcessor getProcessor() {
        return this.processor;
    }

    public ProcessorMatchingContext getContext() {
        return this.context;
    }

    public boolean matches(Node node) {
        return this.processor.getMatcher().matches(node, this.context);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.processor == null ? 0 : this.processor.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessorAndContext other = (ProcessorAndContext)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        return !(this.processor == null ? other.processor != null : !this.processor.equals(other.processor));
    }

    @Override
    public int compareTo(ProcessorAndContext o) {
        return this.processor.compareTo(o.getProcessor());
    }
}

