/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.Template;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.TemplateRepository;
import org.thymeleaf.cache.ICacheManager;
import org.thymeleaf.cache.StandardCacheManager;
import org.thymeleaf.context.DialectAwareProcessingContext;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.ConfigurationException;
import org.thymeleaf.exceptions.NotInitializedException;
import org.thymeleaf.exceptions.TemplateEngineException;
import org.thymeleaf.exceptions.TemplateOutputException;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.fragment.IFragmentSpec;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.templatemode.ITemplateModeHandler;
import org.thymeleaf.templatemode.StandardTemplateModeHandlers;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolution;
import org.thymeleaf.templatewriter.ITemplateWriter;
import org.thymeleaf.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateEngine {
    public static final String TIMER_LOGGER_NAME = TemplateEngine.class.getName() + ".TIMER";
    private static final Logger logger = LoggerFactory.getLogger(TemplateEngine.class);
    private static final Logger timerLogger = LoggerFactory.getLogger((String)TIMER_LOGGER_NAME);
    private static final int NANOS_IN_SECOND = 1000000;
    private final Configuration configuration = new Configuration();
    private TemplateRepository templateRepository;
    private volatile boolean initialized = false;

    public TemplateEngine() {
        this.setCacheManager(new StandardCacheManager());
        this.setDefaultMessageResolvers(Collections.singleton(new StandardMessageResolver()));
        this.setDefaultTemplateModeHandlers(StandardTemplateModeHandlers.ALL_TEMPLATE_MODE_HANDLERS);
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public TemplateRepository getTemplateRepository() {
        if (!this.isInitialized()) {
            throw new NotInitializedException("Template Engine has not been initialized");
        }
        return this.templateRepository;
    }

    public final Map<String, IDialect> getDialectsByPrefix() {
        return this.configuration.getDialects();
    }

    public final Set<IDialect> getDialects() {
        return this.configuration.getDialectSet();
    }

    public void setDialect(IDialect dialect) {
        this.configuration.setDialect(dialect);
    }

    public void addDialect(String prefix, IDialect dialect) {
        this.configuration.addDialect(prefix, dialect);
    }

    public void addDialect(IDialect dialect) {
        this.configuration.addDialect(dialect.getPrefix(), dialect);
    }

    public void setDialectsByPrefix(Map<String, IDialect> dialects) {
        this.configuration.setDialects(dialects);
    }

    public void setDialects(Set<IDialect> dialects) {
        Validate.notNull(dialects, "Dialect set cannot be null");
        LinkedHashMap<String, IDialect> dialectMap = new LinkedHashMap<String, IDialect>(dialects.size() + 2, 1.0f);
        for (IDialect dialect : dialects) {
            dialectMap.put(dialect.getPrefix(), dialect);
        }
        this.configuration.setDialects(dialectMap);
    }

    public void setAdditionalDialects(Set<IDialect> additionalDialects) {
        Validate.notNull(additionalDialects, "Additional dialect set cannot be null");
        LinkedHashMap<String, IDialect> dialectMap = new LinkedHashMap<String, IDialect>(5, 1.0f);
        dialectMap.putAll(this.configuration.getDialects());
        for (IDialect dialect : additionalDialects) {
            dialectMap.put(dialect.getPrefix(), dialect);
        }
        this.configuration.setDialects(dialectMap);
    }

    public void clearDialects() {
        this.configuration.clearDialects();
    }

    public final Set<ITemplateResolver> getTemplateResolvers() {
        return this.configuration.getTemplateResolvers();
    }

    public void setTemplateResolvers(Set<? extends ITemplateResolver> templateResolvers) {
        this.configuration.setTemplateResolvers(templateResolvers);
    }

    public void addTemplateResolver(ITemplateResolver templateResolver) {
        this.configuration.addTemplateResolver(templateResolver);
    }

    public void setTemplateResolver(ITemplateResolver templateResolver) {
        this.configuration.setTemplateResolver(templateResolver);
    }

    public ICacheManager getCacheManager() {
        return this.configuration.getCacheManager();
    }

    public void setCacheManager(ICacheManager cacheManager) {
        this.configuration.setCacheManager(cacheManager);
    }

    public final Set<IMessageResolver> getMessageResolvers() {
        return this.configuration.getMessageResolvers();
    }

    public void setMessageResolvers(Set<? extends IMessageResolver> messageResolvers) {
        this.configuration.setMessageResolvers(messageResolvers);
    }

    public void addMessageResolver(IMessageResolver messageResolver) {
        this.configuration.addMessageResolver(messageResolver);
    }

    public void setMessageResolver(IMessageResolver messageResolver) {
        this.configuration.setMessageResolver(messageResolver);
    }

    public void setDefaultMessageResolvers(Set<? extends IMessageResolver> defaultMessageResolvers) {
        this.configuration.setDefaultMessageResolvers(defaultMessageResolvers);
    }

    public final Set<ITemplateModeHandler> getTemplateModeHandlers() {
        return this.configuration.getTemplateModeHandlers();
    }

    public void setTemplateModeHandlers(Set<? extends ITemplateModeHandler> templateModeHandlers) {
        this.configuration.setTemplateModeHandlers(templateModeHandlers);
    }

    public void addTemplateModeHandler(ITemplateModeHandler templateModeHandler) {
        this.configuration.addTemplateModeHandler(templateModeHandler);
    }

    public void setDefaultTemplateModeHandlers(Set<? extends ITemplateModeHandler> defaultTemplateModeHandlers) {
        this.configuration.setDefaultTemplateModeHandlers(defaultTemplateModeHandlers);
    }

    public void clearTemplateCache() {
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.templateRepository.clearTemplateCache();
    }

    public void clearTemplateCacheFor(String templateName) {
        Validate.notNull(templateName, "Template name cannot be null");
        if (!this.isInitialized()) {
            this.initialize();
        }
        this.templateRepository.clearTemplateCacheFor(templateName);
    }

    public final synchronized void initialize() {
        if (!this.isInitialized()) {
            logger.info("[THYMELEAF] INITIALIZING TEMPLATE ENGINE");
            this.configuration.initialize();
            this.templateRepository = new TemplateRepository(this.configuration);
            this.initializeSpecific();
            this.initialized = true;
            this.configuration.printConfiguration();
            logger.info("[THYMELEAF] TEMPLATE ENGINE INITIALIZED");
        }
    }

    protected void initializeSpecific() {
    }

    public static String threadIndex() {
        return Thread.currentThread().getName();
    }

    public final String process(String templateName, IContext context) {
        return this.process(templateName, context, (IFragmentSpec)null);
    }

    public final String process(String templateName, IContext context, IFragmentSpec fragmentSpec) {
        StringWriter stringWriter = new StringWriter();
        this.process(templateName, context, fragmentSpec, (Writer)stringWriter);
        return stringWriter.toString();
    }

    public final void process(String templateName, IContext context, Writer writer) {
        this.process(templateName, context, null, writer);
    }

    public final void process(String templateName, IProcessingContext processingContext, Writer writer) {
        this.process(templateName, processingContext, null, writer);
    }

    public final void process(String templateName, IContext context, IFragmentSpec fragmentSpec, Writer writer) {
        this.process(templateName, new DialectAwareProcessingContext(context, this.getDialects()), fragmentSpec, writer);
    }

    public final void process(String templateName, IProcessingContext processingContext, IFragmentSpec fragmentSpec, Writer writer) {
        if (!this.isInitialized()) {
            this.initialize();
        }
        try {
            Validate.notNull(templateName, "Template name cannot be null");
            Validate.notNull(processingContext, "Processing context cannot be null");
            IContext context = processingContext.getContext();
            long startNanos = System.nanoTime();
            if (logger.isDebugEnabled()) {
                logger.debug("[THYMELEAF][{}] STARTING PROCESS OF TEMPLATE \"{}\" WITH LOCALE {}", new Object[]{TemplateEngine.threadIndex(), templateName, context.getLocale()});
            }
            context.addContextExecutionInfo(templateName);
            TemplateProcessingParameters templateProcessingParameters = new TemplateProcessingParameters(this.configuration, templateName, processingContext);
            this.process(templateProcessingParameters, fragmentSpec, writer);
            long endNanos = System.nanoTime();
            if (logger.isDebugEnabled()) {
                logger.debug("[THYMELEAF][{}] FINISHED PROCESS AND OUTPUT OF TEMPLATE \"{}\" WITH LOCALE {}", new Object[]{TemplateEngine.threadIndex(), templateName, context.getLocale()});
            }
            if (timerLogger.isDebugEnabled()) {
                BigDecimal elapsed = BigDecimal.valueOf(endNanos - startNanos);
                BigDecimal elapsedMs = elapsed.divide(BigDecimal.valueOf(1000000L), RoundingMode.HALF_UP);
                timerLogger.debug("[THYMELEAF][{}][{}][{}][{}][{}] TEMPLATE \"{}\" WITH LOCALE {} PROCESSED IN {} nanoseconds (approx. {}ms)", new Object[]{TemplateEngine.threadIndex(), templateName, context.getLocale(), elapsed, elapsedMs, templateName, context.getLocale(), elapsed, elapsedMs});
            }
        }
        catch (TemplateOutputException e) {
            logger.error("[THYMELEAF][{}] Exception processing template \"{}\": {}", new Object[]{TemplateEngine.threadIndex(), templateName, e.getMessage()});
            throw e;
        }
        catch (TemplateEngineException e) {
            logger.error("[THYMELEAF][{}] Exception processing template \"{}\": {}", new Object[]{TemplateEngine.threadIndex(), templateName, e.getMessage()});
            throw e;
        }
        catch (RuntimeException e) {
            logger.error("[THYMELEAF][{}] Exception processing template \"{}\": {}", new Object[]{TemplateEngine.threadIndex(), templateName, e.getMessage()});
            throw new TemplateProcessingException("Exception processing template", templateName, e);
        }
    }

    private void process(TemplateProcessingParameters templateProcessingParameters, IFragmentSpec fragmentSpec, Writer writer) {
        ITemplateModeHandler templateModeHandler;
        ITemplateWriter templateWriter;
        String templateName = templateProcessingParameters.getTemplateName();
        Template template = this.templateRepository.getTemplate(templateProcessingParameters);
        TemplateResolution templateResolution = template.getTemplateResolution();
        String templateMode = templateResolution.getTemplateMode();
        Document document = template.getDocument();
        if (fragmentSpec != null) {
            List<Node> processingRootNodes = fragmentSpec.extractFragment(this.configuration, Collections.singletonList(document));
            if (processingRootNodes == null || processingRootNodes.size() == 0) {
                document = null;
            } else {
                Node firstProcessingRootNode = processingRootNodes.get(0);
                if (processingRootNodes.size() == 1 && firstProcessingRootNode != null && firstProcessingRootNode instanceof Document) {
                    document = (Document)firstProcessingRootNode;
                } else {
                    String documentName = document.getDocumentName();
                    document = new Document(documentName);
                    for (Node processingRootNode : processingRootNodes) {
                        if (processingRootNode == null) continue;
                        Node clonedProcessingRootNode = processingRootNode.cloneNode(document, false);
                        document.addChild(clonedProcessingRootNode);
                    }
                    document.precompute(this.configuration);
                }
            }
        }
        Arguments arguments = new Arguments(this, templateProcessingParameters, templateResolution, this.templateRepository, document);
        if (logger.isDebugEnabled()) {
            logger.debug("[THYMELEAF][{}] Starting process on template \"{}\" using mode \"{}\"", new Object[]{TemplateEngine.threadIndex(), templateName, templateMode});
        }
        if (document != null) {
            document.process(arguments);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[THYMELEAF][{}] Finished process on template \"{}\" using mode \"{}\"", new Object[]{TemplateEngine.threadIndex(), templateName, templateMode});
        }
        if ((templateWriter = (templateModeHandler = this.configuration.getTemplateModeHandler(templateMode)).getTemplateWriter()) == null) {
            throw new ConfigurationException("No template writer defined for template mode \"" + templateMode + "\"");
        }
        try {
            templateWriter.write(arguments, writer, document);
        }
        catch (IOException e) {
            throw new TemplateOutputException("Error during creation of output", e);
        }
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new TemplateOutputException("An error happened while flushing output writer", e);
        }
    }
}

