/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.expression;

import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.standard.expression.EqualsNotEqualsExpression;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.LiteralValue;
import org.thymeleaf.standard.expression.StandardExpressionExecutionContext;
import org.thymeleaf.util.EvaluationUtil;

public final class EqualsExpression
extends EqualsNotEqualsExpression {
    private static final long serialVersionUID = -3223406642461547141L;
    private static final Logger logger = LoggerFactory.getLogger(EqualsExpression.class);

    public EqualsExpression(IStandardExpression left, IStandardExpression right) {
        super(left, right);
    }

    public String getStringRepresentation() {
        return this.getStringRepresentation("==");
    }

    static Object executeEquals(Configuration configuration, IProcessingContext processingContext, EqualsExpression expression, StandardExpressionExecutionContext expContext) {
        Object leftValue = expression.getLeft().execute(configuration, processingContext, expContext);
        Object rightValue = expression.getRight().execute(configuration, processingContext, expContext);
        leftValue = LiteralValue.unwrap(leftValue);
        rightValue = LiteralValue.unwrap(rightValue);
        if (leftValue == null) {
            return rightValue == null;
        }
        Boolean result = null;
        BigDecimal leftNumberValue = EvaluationUtil.evaluateAsNumber(leftValue);
        BigDecimal rightNumberValue = EvaluationUtil.evaluateAsNumber(rightValue);
        if (leftNumberValue != null && rightNumberValue != null) {
            result = leftNumberValue.compareTo(rightNumberValue) == 0;
        } else {
            if (leftValue instanceof Character) {
                leftValue = leftValue.toString();
            }
            if (rightValue != null && rightValue instanceof Character) {
                rightValue = rightValue.toString();
            }
            result = rightValue != null && leftValue.getClass().equals(rightValue.getClass()) && Comparable.class.isAssignableFrom(leftValue.getClass()) ? Boolean.valueOf(((Comparable)leftValue).compareTo(rightValue) == 0) : Boolean.valueOf(leftValue.equals(rightValue));
        }
        if (logger.isTraceEnabled()) {
            logger.trace("[THYMELEAF][{}] Evaluating EQUALS expression: \"{}\". Left is \"{}\", right is \"{}\". Result is \"{}\"", new Object[]{TemplateEngine.threadIndex(), expression.getStringRepresentation(), leftValue, rightValue, result});
        }
        return result;
    }
}

