/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import java.util.HashMap;
import java.util.List;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.NestableNode;
import org.thymeleaf.dom.Node;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.IAttributeNameProcessorMatcher;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.standard.inliner.IStandardTextInliner;
import org.thymeleaf.standard.inliner.StandardDartTextInliner;
import org.thymeleaf.standard.inliner.StandardJavaScriptTextInliner;
import org.thymeleaf.standard.inliner.StandardTextTextInliner;

public abstract class AbstractStandardTextInlinerAttrProcessor
extends AbstractAttrProcessor {
    public static final String TEXT_INLINE = "text";
    public static final String JAVASCRIPT_INLINE = "javascript";
    public static final String DART_INLINE = "dart";
    public static final String NONE_INLINE = "none";

    protected AbstractStandardTextInlinerAttrProcessor(IAttributeNameProcessorMatcher matcher) {
        super(matcher);
    }

    protected AbstractStandardTextInlinerAttrProcessor(String attributeName) {
        super(attributeName);
    }

    public final ProcessorResult processAttribute(Arguments arguments, Element element, String attributeName) {
        IStandardTextInliner textInliner = AbstractStandardTextInlinerAttrProcessor.getTextInliner(element, attributeName);
        HashMap<String, Object> localVariables = new HashMap<String, Object>(2, 1.0f);
        localVariables.put("%STANDARD_INLINER%", textInliner);
        AbstractStandardTextInlinerAttrProcessor.ensureChildrenArePrecomputed(element);
        element.removeAttribute(attributeName);
        return ProcessorResult.setLocalVariablesAndProcessTextNodes(localVariables, true);
    }

    protected static IStandardTextInliner getTextInliner(Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        if (attributeValue != null) {
            if (JAVASCRIPT_INLINE.equals(attributeValue.toLowerCase())) {
                return StandardJavaScriptTextInliner.INSTANCE;
            }
            if (DART_INLINE.equals(attributeValue.toLowerCase())) {
                return StandardDartTextInliner.INSTANCE;
            }
            if (TEXT_INLINE.equals(attributeValue.toLowerCase())) {
                return StandardTextTextInliner.INSTANCE;
            }
            if (NONE_INLINE.equals(attributeValue.toLowerCase())) {
                return null;
            }
        }
        throw new TemplateProcessingException("Cannot recognize value for \"" + attributeName + "\". Allowed values are \"" + TEXT_INLINE + "\", \"" + JAVASCRIPT_INLINE + "\", \"" + DART_INLINE + "\" and \"" + NONE_INLINE + "\"");
    }

    private static void ensureChildrenArePrecomputed(Node node) {
        if (node != null) {
            node.setRecomputeProcessorsImmediately(true);
            if (node instanceof NestableNode) {
                List<Node> children = ((NestableNode)node).getChildren();
                for (Node child : children) {
                    AbstractStandardTextInlinerAttrProcessor.ensureChildrenArePrecomputed(child);
                }
            }
        }
    }
}

