/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor.attr;

import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.dom.Element;
import org.thymeleaf.exceptions.TemplateProcessingException;
import org.thymeleaf.processor.attr.AbstractMarkupRemovalAttrProcessor;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;

public final class StandardRemoveAttrProcessor
extends AbstractMarkupRemovalAttrProcessor {
    public static final int ATTR_PRECEDENCE = 1600;
    public static final String ATTR_NAME = "remove";
    public static final String VALUE_ALL = "all";
    public static final String VALUE_ALL_BUT_FIRST = "all-but-first";
    public static final String VALUE_TAG = "tag";
    public static final String VALUE_BODY = "body";
    public static final String VALUE_NONE = "none";

    public StandardRemoveAttrProcessor() {
        super(ATTR_NAME);
    }

    public int getPrecedence() {
        return 1600;
    }

    protected AbstractMarkupRemovalAttrProcessor.RemovalType getRemovalType(Arguments arguments, Element element, String attributeName) {
        String attributeValue = element.getAttributeValue(attributeName);
        Configuration configuration = arguments.getConfiguration();
        IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser(configuration);
        IStandardExpression expression = expressionParser.parseExpression(configuration, arguments, attributeValue);
        Object result = expression.execute(configuration, arguments);
        if (result == null) {
            return AbstractMarkupRemovalAttrProcessor.RemovalType.NONE;
        }
        String resultStr = result.toString();
        if (VALUE_ALL.equalsIgnoreCase(resultStr)) {
            return AbstractMarkupRemovalAttrProcessor.RemovalType.ALL;
        }
        if (VALUE_NONE.equalsIgnoreCase(resultStr)) {
            return AbstractMarkupRemovalAttrProcessor.RemovalType.NONE;
        }
        if (VALUE_TAG.equalsIgnoreCase(resultStr)) {
            return AbstractMarkupRemovalAttrProcessor.RemovalType.ELEMENT;
        }
        if (VALUE_ALL_BUT_FIRST.equalsIgnoreCase(resultStr)) {
            return AbstractMarkupRemovalAttrProcessor.RemovalType.ALLBUTFIRST;
        }
        if (VALUE_BODY.equalsIgnoreCase(resultStr)) {
            return AbstractMarkupRemovalAttrProcessor.RemovalType.BODY;
        }
        throw new TemplateProcessingException("Invalid value specified for \"" + attributeName + "\": only 'all', 'tag', 'body', 'none' and 'all-but-first' are allowed, but \"" + attributeValue + "\" was specified.");
    }
}

