/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.thymeleaf.engine.ISSEThrottledTemplateWriterControl;
import org.thymeleaf.engine.IThrottledTemplateWriterControl;
import org.thymeleaf.exceptions.TemplateProcessingException;

public final class DataDrivenTemplateIterator
implements Iterator<Object> {
    private static final String SSE_HEAD_EVENT_TYPE = "head";
    private static final String SSE_MESSAGE_EVENT_TYPE = "message";
    private static final String SSE_TAIL_EVENT_TYPE = "tail";
    private final List<Object> values = new ArrayList<Object>(10);
    private IThrottledTemplateWriterControl writerControl = null;
    private ISSEThrottledTemplateWriterControl sseControl = null;
    private long sseEventID = 0L;
    private boolean inStep = false;
    private boolean feedingComplete = false;
    private boolean queried = false;

    public void setWriterControl(IThrottledTemplateWriterControl writerControl) {
        this.writerControl = writerControl;
        this.sseControl = writerControl instanceof ISSEThrottledTemplateWriterControl ? (ISSEThrottledTemplateWriterControl)this.writerControl : null;
    }

    public void setFirstSSEEventID(long firstSSEEventID) {
        this.sseEventID = firstSSEEventID;
    }

    public void takeBackLastEventID() {
        if (this.sseEventID > 0L) {
            --this.sseEventID;
        }
    }

    @Override
    public boolean hasNext() {
        this.queried = true;
        return !this.values.isEmpty();
    }

    @Override
    public Object next() {
        this.queried = true;
        if (this.values.isEmpty()) {
            throw new NoSuchElementException();
        }
        Object value = this.values.get(0);
        this.values.remove(0);
        return value;
    }

    public void startIteration() {
        this.inStep = true;
        if (this.sseControl != null) {
            this.sseControl.startEvent(Long.toString(this.sseEventID), SSE_MESSAGE_EVENT_TYPE);
            ++this.sseEventID;
        }
    }

    public void finishIteration() {
        this.finishStep();
    }

    public boolean hasBeenQueried() {
        return this.queried;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() is not supported in Throttled Iterator");
    }

    boolean isPaused() {
        this.queried = true;
        return this.values.isEmpty() && !this.feedingComplete;
    }

    public boolean continueBufferExecution() {
        return !this.values.isEmpty();
    }

    public void feedBuffer(List<Object> newElements) {
        this.values.addAll(newElements);
    }

    public void startHead() {
        this.inStep = true;
        if (this.sseControl != null) {
            this.sseControl.startEvent(Long.toString(this.sseEventID), SSE_HEAD_EVENT_TYPE);
            ++this.sseEventID;
        }
    }

    public void feedingComplete() {
        this.feedingComplete = true;
    }

    public void startTail() {
        this.inStep = true;
        if (this.sseControl != null) {
            this.sseControl.startEvent(Long.toString(this.sseEventID), SSE_TAIL_EVENT_TYPE);
            ++this.sseEventID;
        }
    }

    public void finishStep() {
        if (!this.inStep) {
            return;
        }
        this.inStep = false;
        if (this.sseControl != null) {
            try {
                this.sseControl.endEvent();
            }
            catch (IOException e) {
                throw new TemplateProcessingException("Cannot signal end of SSE event", e);
            }
        }
    }

    public boolean isStepOutputFinished() {
        if (this.inStep) {
            return false;
        }
        if (this.writerControl != null) {
            try {
                return !this.writerControl.isOverflown();
            }
            catch (IOException e) {
                throw new TemplateProcessingException("Cannot signal end of SSE event", e);
            }
        }
        return true;
    }
}

