/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.engine;

import java.io.IOException;
import org.thymeleaf.engine.ISSEThrottledTemplateWriterControl;
import org.thymeleaf.engine.TemplateFlowController;
import org.thymeleaf.engine.ThrottledTemplateWriter;

class SSEThrottledTemplateWriter
extends ThrottledTemplateWriter
implements ISSEThrottledTemplateWriterControl {
    private static final char[] SSE_ID_PREFIX = "id: ".toCharArray();
    private static final char[] SSE_EVENT_PREFIX = "event: ".toCharArray();
    private static final char[] SSE_DATA_PREFIX = "data: ".toCharArray();
    private String id = null;
    private String event = null;
    private boolean eventHasMeta = false;
    private boolean newEvent = true;

    SSEThrottledTemplateWriter(String templateName, TemplateFlowController flowController) {
        super(templateName, flowController);
    }

    @Override
    public void startEvent(String id, String event) {
        this.newEvent = true;
        this.id = id;
        this.event = event;
    }

    private void doStartEvent() throws IOException {
        this.eventHasMeta = false;
        if (this.event != null) {
            if (this.event.indexOf(10) != -1) {
                throw new IllegalArgumentException("Event for SSE event cannot contain a newline (\\n) character");
            }
            super.write(SSE_EVENT_PREFIX);
            super.write(this.event.toCharArray());
            super.write(10);
            this.eventHasMeta = true;
        }
        if (this.id != null) {
            if (this.id.indexOf(10) != -1) {
                throw new IllegalArgumentException("ID for SSE event cannot contain a newline (\\n) character");
            }
            super.write(SSE_ID_PREFIX);
            super.write(this.id.toCharArray());
            super.write(10);
            this.eventHasMeta = true;
        }
    }

    @Override
    public void endEvent() throws IOException {
        if (!this.newEvent) {
            super.write(10);
            super.write(10);
        } else if (this.eventHasMeta) {
            super.write(10);
        }
    }

    @Override
    public void write(int c) throws IOException {
        if (this.newEvent) {
            this.doStartEvent();
            super.write(SSE_DATA_PREFIX);
            this.newEvent = false;
        }
        super.write(c);
        if (c == 10) {
            super.write(SSE_DATA_PREFIX);
        }
    }

    @Override
    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        int i;
        if (str == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > str.length() || len < 0 || off + len > str.length() || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            super.write(str, off, len);
            return;
        }
        if (this.newEvent) {
            this.doStartEvent();
            super.write(SSE_DATA_PREFIX);
            this.newEvent = false;
        }
        int x = i = off;
        int maxi = off + len;
        while (i < maxi) {
            char c;
            if ((c = str.charAt(i++)) != '\n') continue;
            super.write(str, x, i - x);
            super.write(SSE_DATA_PREFIX);
            x = i;
        }
        if (x < i) {
            super.write(str, x, i - x);
        }
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        this.write(cbuf, 0, cbuf.length);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int i;
        if (cbuf == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            super.write(cbuf, off, len);
            return;
        }
        if (this.newEvent) {
            this.doStartEvent();
            super.write(SSE_DATA_PREFIX);
            this.newEvent = false;
        }
        int x = i = off;
        int maxi = off + len;
        while (i < maxi) {
            char c;
            if ((c = cbuf[i++]) != '\n') continue;
            super.write(cbuf, x, i - x);
            super.write(SSE_DATA_PREFIX);
            x = i;
        }
        if (x < i) {
            super.write(cbuf, x, i - x);
        }
    }
}

