/*
 * Decompiled with CFR 0.152.
 */
package org.thymeleaf.standard.processor;

import org.thymeleaf.context.ITemplateContext;
import org.thymeleaf.engine.AttributeDefinition;
import org.thymeleaf.engine.AttributeDefinitions;
import org.thymeleaf.engine.AttributeName;
import org.thymeleaf.engine.IAttributeDefinitionsAware;
import org.thymeleaf.model.IProcessableElementTag;
import org.thymeleaf.processor.element.IElementTagStructureHandler;
import org.thymeleaf.standard.processor.AbstractStandardExpressionAttributeTagProcessor;
import org.thymeleaf.standard.util.StandardProcessorUtils;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.util.EscapedAttributeUtils;
import org.thymeleaf.util.Validate;

public final class StandardStyleappendTagProcessor
extends AbstractStandardExpressionAttributeTagProcessor
implements IAttributeDefinitionsAware {
    public static final int PRECEDENCE = 1100;
    public static final String ATTR_NAME = "styleappend";
    public static final String TARGET_ATTR_NAME = "style";
    private static final TemplateMode TEMPLATE_MODE = TemplateMode.HTML;
    private AttributeDefinition targetAttributeDefinition;

    public StandardStyleappendTagProcessor(String dialectPrefix) {
        super(TemplateMode.HTML, dialectPrefix, ATTR_NAME, 1100, true);
    }

    @Override
    public void setAttributeDefinitions(AttributeDefinitions attributeDefinitions) {
        Validate.notNull(attributeDefinitions, "Attribute Definitions cannot be null");
        this.targetAttributeDefinition = attributeDefinitions.forName(TEMPLATE_MODE, TARGET_ATTR_NAME);
    }

    @Override
    protected final void doProcess(ITemplateContext context, IProcessableElementTag tag, AttributeName attributeName, String attributeValue, Object expressionResult, IElementTagStructureHandler structureHandler) {
        String newAttributeValue = EscapedAttributeUtils.escapeAttribute(this.getTemplateMode(), expressionResult == null ? null : expressionResult.toString());
        if (newAttributeValue != null && newAttributeValue.length() > 0) {
            String currentValue;
            AttributeName targetAttributeName = this.targetAttributeDefinition.getAttributeName();
            if (tag.hasAttribute(targetAttributeName) && (currentValue = tag.getAttributeValue(targetAttributeName)).length() > 0) {
                newAttributeValue = currentValue + ' ' + newAttributeValue;
            }
            StandardProcessorUtils.setAttribute(structureHandler, this.targetAttributeDefinition, TARGET_ATTR_NAME, newAttributeValue);
        }
    }
}

