/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.provider;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.tinylog.provider.ContextProvider;

final class BundleContextProvider
implements ContextProvider {
    private final ContextProvider[] providers;

    BundleContextProvider(Collection<ContextProvider> providers) {
        this.providers = providers.toArray(new ContextProvider[0]);
    }

    @Override
    public Map<String, String> getMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (int i = 0; i < this.providers.length; ++i) {
            mapping.putAll(this.providers[i].getMapping());
        }
        return mapping;
    }

    @Override
    public String get(String key) {
        for (int i = 0; i < this.providers.length; ++i) {
            String value = this.providers[i].get(key);
            if (value == null) continue;
            return value;
        }
        return null;
    }

    @Override
    public void put(String key, Object value) {
        for (int i = 0; i < this.providers.length; ++i) {
            this.providers[i].put(key, value);
        }
    }

    @Override
    public void remove(String key) {
        for (int i = 0; i < this.providers.length; ++i) {
            this.providers[i].remove(key);
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.providers.length; ++i) {
            this.providers[i].clear();
        }
    }
}

