/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.executor.config;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.lang.NonNull;
import top.dcenter.ums.security.core.executor.config.ExecutorPropertiesAutoConfiguration;
import top.dcenter.ums.security.core.executor.properties.ExecutorProperties;

@Configuration
@AutoConfigureAfter(value={ExecutorPropertiesAutoConfiguration.class})
public class ExecutorAutoConfiguration
implements DisposableBean {
    private final ExecutorProperties executorProperties;
    private ScheduledExecutorService jobTaskScheduledExecutor;
    private ExecutorService updateConnectionExecutorService;
    private ExecutorService refreshTokenExecutorService;

    public ExecutorAutoConfiguration(ExecutorProperties executorProperties) {
        this.executorProperties = executorProperties;
    }

    @Bean
    public ScheduledExecutorService jobTaskScheduledExecutor() {
        ExecutorProperties.JobTaskScheduledExecutorProperties jobTaskScheduledExecutor = this.executorProperties.getJobTaskScheduledExecutor();
        ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(jobTaskScheduledExecutor.getCorePoolSize(), this.getThreadFactory(jobTaskScheduledExecutor.getPoolName()), jobTaskScheduledExecutor.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        scheduledThreadPoolExecutor.setKeepAliveTime(jobTaskScheduledExecutor.getKeepAliveTime().intValue(), jobTaskScheduledExecutor.getTimeUnit());
        this.jobTaskScheduledExecutor = scheduledThreadPoolExecutor;
        return scheduledThreadPoolExecutor;
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-refresh-token-job"}, havingValue="true")
    public ExecutorService refreshTokenTaskExecutor() {
        ExecutorProperties.RefreshTokenExecutorProperties refreshToken = this.executorProperties.getRefreshToken();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(refreshToken.getCorePoolSize(), refreshToken.getMaximumPoolSize(), refreshToken.getKeepAliveTime().intValue(), refreshToken.getTimeUnit(), new LinkedBlockingQueue<Runnable>(refreshToken.getBlockingQueueCapacity()), this.getThreadFactory(refreshToken.getPoolName()), refreshToken.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.refreshTokenExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    @Bean(destroyMethod="shutdown")
    public ExecutorService updateConnectionTaskExecutor() {
        ExecutorProperties.UserConnectionUpdateExecutorProperties userConnectionUpdate = this.executorProperties.getUserConnectionUpdate();
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(userConnectionUpdate.getCorePoolSize(), userConnectionUpdate.getMaximumPoolSize(), userConnectionUpdate.getKeepAliveTime().intValue(), userConnectionUpdate.getTimeUnit(), new LinkedBlockingQueue<Runnable>(userConnectionUpdate.getBlockingQueueCapacity()), this.getThreadFactory(userConnectionUpdate.getPoolName()), userConnectionUpdate.getRejectedExecutionHandlerPolicy().getRejectedHandler());
        this.updateConnectionExecutorService = threadPoolExecutor;
        return threadPoolExecutor;
    }

    private ThreadFactory getThreadFactory(String poolName) {
        return new DefaultThreadFactory(poolName);
    }

    public void shutdown() throws Exception {
        if (this.updateConnectionExecutorService != null) {
            this.updateConnectionExecutorService.shutdown();
            this.updateConnectionExecutorService.awaitTermination(this.executorProperties.getUserConnectionUpdate().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.updateConnectionExecutorService.isTerminated()) {
                this.updateConnectionExecutorService.shutdownNow();
            }
        }
    }

    public void destroy() throws Exception {
        if (this.refreshTokenExecutorService != null) {
            this.refreshTokenExecutorService.shutdown();
            this.refreshTokenExecutorService.awaitTermination(this.executorProperties.getJobTaskScheduledExecutor().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.refreshTokenExecutorService.isTerminated()) {
                this.refreshTokenExecutorService.shutdownNow();
            }
        }
        if (this.jobTaskScheduledExecutor != null) {
            this.jobTaskScheduledExecutor.shutdown();
            this.jobTaskScheduledExecutor.awaitTermination(this.executorProperties.getJobTaskScheduledExecutor().getExecutorShutdownTimeout().toMillis(), TimeUnit.MILLISECONDS);
            if (!this.jobTaskScheduledExecutor.isTerminated()) {
                this.jobTaskScheduledExecutor.shutdownNow();
            }
        }
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DefaultThreadFactory(String poolName) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = poolName + "-" + POOL_NUMBER.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(@NonNull Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

