/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.concurrent.ExecutorService;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.security.crypto.encrypt.Encryptors;
import org.springframework.security.crypto.encrypt.TextEncryptor;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.oauth.config.Auth2PropertiesAutoConfiguration;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJob;
import top.dcenter.ums.security.core.oauth.job.RefreshTokenJobImpl;
import top.dcenter.ums.security.core.oauth.justauth.Auth2RequestHolder;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.RepositoryProperties;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository;
import top.dcenter.ums.security.core.oauth.repository.factory.Auth2JdbcUsersConnectionRepositoryFactory;
import top.dcenter.ums.security.core.oauth.repository.factory.UsersConnectionRepositoryFactory;
import top.dcenter.ums.security.core.oauth.repository.jdbc.Auth2JdbcUsersConnectionTokenRepository;
import top.dcenter.ums.security.core.oauth.service.Auth2StateCoder;
import top.dcenter.ums.security.core.oauth.service.Auth2UserService;
import top.dcenter.ums.security.core.oauth.service.DefaultAuth2UserServiceImpl;
import top.dcenter.ums.security.core.oauth.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.oauth.signup.ConnectionService;
import top.dcenter.ums.security.core.oauth.signup.DefaultConnectionServiceImpl;
import top.dcenter.ums.security.core.oauth.userdetails.converter.AuthenticationToUserDetailsConverter;
import top.dcenter.ums.security.core.oauth.userdetails.converter.Oauth2TokenAuthenticationTokenToUserConverter;

@Configuration
@AutoConfigureAfter(value={Auth2PropertiesAutoConfiguration.class})
public class Auth2AutoConfiguration
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(Auth2AutoConfiguration.class);
    private final RepositoryProperties repositoryProperties;
    private final Auth2Properties auth2Properties;
    private final DataSource dataSource;

    public Auth2AutoConfiguration(RepositoryProperties repositoryProperties, Auth2Properties auth2Properties, DataSource dataSource) {
        this.repositoryProperties = repositoryProperties;
        this.auth2Properties = auth2Properties;
        this.dataSource = dataSource;
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.userdetails.converter.AuthenticationToUserDetailsConverter"})
    public AuthenticationToUserDetailsConverter authenticationToUserDetailsConverter() {
        return new Oauth2TokenAuthenticationTokenToUserConverter();
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.service.Auth2UserService"})
    public Auth2UserService auth2UserService() {
        return new DefaultAuth2UserServiceImpl();
    }

    @Bean
    @ConditionalOnMissingBean(type={"org.springframework.jdbc.core.JdbcTemplate"})
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-user-connection-and-auth-token-table"}, havingValue="true")
    public JdbcTemplate auth2UserConnectionJdbcTemplate() {
        return new JdbcTemplate(this.dataSource);
    }

    @Bean
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-user-connection-and-auth-token-table"}, havingValue="true")
    public UsersConnectionRepository usersConnectionRepository(UsersConnectionRepositoryFactory usersConnectionRepositoryFactory, JdbcTemplate auth2UserConnectionJdbcTemplate, @Qualifier(value="connectionTextEncryptor") TextEncryptor connectionTextEncryptor) {
        return usersConnectionRepositoryFactory.getUsersConnectionRepository(auth2UserConnectionJdbcTemplate, connectionTextEncryptor, this.repositoryProperties);
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.repository.factory.UsersConnectionRepositoryFactory"})
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-user-connection-and-auth-token-table"}, havingValue="true")
    public UsersConnectionRepositoryFactory usersConnectionRepositoryFactory() {
        return new Auth2JdbcUsersConnectionRepositoryFactory();
    }

    @Bean
    public TextEncryptor connectionTextEncryptor(RepositoryProperties repositoryProperties) {
        return Encryptors.text((CharSequence)repositoryProperties.getTextEncryptorPassword(), (CharSequence)repositoryProperties.getTextEncryptorSalt());
    }

    @Bean
    @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.signup.ConnectionService"})
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-user-connection-and-auth-token-table"}, havingValue="true")
    public ConnectionService connectionSignUp(UmsUserDetailsService userDetailsService, @Autowired(required=false) UsersConnectionTokenRepository usersConnectionTokenRepository, UsersConnectionRepository usersConnectionRepository, @Autowired(required=false) Auth2StateCoder auth2StateCoder) {
        return new DefaultConnectionServiceImpl(userDetailsService, this.auth2Properties, usersConnectionRepository, usersConnectionTokenRepository, auth2StateCoder);
    }

    @Bean
    public Auth2RequestHolder auth2RequestHolder() {
        return Auth2RequestHolder.getInstance();
    }

    public void afterPropertiesSet() throws Exception {
        block108: {
            if (!this.repositoryProperties.getEnableStartUpInitializeTable().booleanValue() || !this.auth2Properties.getEnableUserConnectionAndAuthTokenTable().booleanValue()) {
                return;
            }
            try (Connection connection = this.dataSource.getConnection();){
                String database;
                if (connection == null) {
                    log.error("\u9519\u8bef: \u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 {} \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", (Object)this.repositoryProperties.getUserConnectionTableName());
                    throw new Exception(String.format("\u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 %s \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", this.repositoryProperties.getUserConnectionTableName()));
                }
                try (PreparedStatement preparedStatement = connection.prepareStatement(this.repositoryProperties.getQueryDatabaseNameSql());
                     ResultSet resultSet = preparedStatement.executeQuery();){
                    resultSet.next();
                    database = resultSet.getString(1);
                }
                if (StringUtils.hasText((String)database)) {
                    Throwable throwable;
                    ResultSet resultSet2;
                    Throwable throwable2;
                    block107: {
                        String queryUserConnectionTableExistSql = this.repositoryProperties.getQueryUserConnectionTableExistSql(database);
                        throwable2 = null;
                        try (PreparedStatement preparedStatement1 = connection.prepareStatement(queryUserConnectionTableExistSql);){
                            resultSet2 = preparedStatement1.executeQuery();
                            throwable = null;
                            try {
                                resultSet2.next();
                                int tableCount = resultSet2.getInt(1);
                                if (tableCount >= 1) break block107;
                                String creatUserConnectionTableSql = this.repositoryProperties.getCreatUserConnectionTableSql();
                                try (PreparedStatement preparedStatement = connection.prepareStatement(creatUserConnectionTableSql);){
                                    preparedStatement.executeUpdate();
                                    log.info("{} \u8868\u521b\u5efa\u6210\u529f\uff0cSQL\uff1a{}", (Object)this.repositoryProperties.getUserConnectionTableName(), (Object)creatUserConnectionTableSql);
                                    if (!connection.getAutoCommit()) {
                                        connection.commit();
                                    }
                                }
                            }
                            catch (Throwable tableCount) {
                                throwable = tableCount;
                                throw tableCount;
                            }
                            finally {
                                if (resultSet2 != null) {
                                    if (throwable != null) {
                                        try {
                                            resultSet2.close();
                                        }
                                        catch (Throwable tableCount) {
                                            throwable.addSuppressed(tableCount);
                                        }
                                    } else {
                                        resultSet2.close();
                                    }
                                }
                            }
                        }
                        catch (Throwable resultSet2) {
                            throwable2 = resultSet2;
                            throw resultSet2;
                        }
                    }
                    if (!this.auth2Properties.getEnableAuthTokenTable().booleanValue()) {
                        return;
                    }
                    throwable2 = null;
                    try (PreparedStatement preparedStatement2 = connection.prepareStatement(this.repositoryProperties.getQueryAuthTokenTableExistSql(database));){
                        resultSet2 = preparedStatement2.executeQuery();
                        throwable = null;
                        try {
                            resultSet2.next();
                            int tableCount = resultSet2.getInt(1);
                            if (tableCount < 1) {
                                String createAuthTokenTableSql = this.repositoryProperties.getCreateAuthTokenTableSql();
                                connection.prepareStatement(createAuthTokenTableSql).executeUpdate();
                                log.info("{} \u8868\u521b\u5efa\u6210\u529f\uff0cSQL\uff1a{}", (Object)this.repositoryProperties.getAuthTokenTableName(), (Object)createAuthTokenTableSql);
                                if (!connection.getAutoCommit()) {
                                    connection.commit();
                                }
                            }
                            break block108;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (resultSet2 != null) {
                                if (throwable != null) {
                                    try {
                                        resultSet2.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    resultSet2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable2 = throwable5;
                        throw throwable5;
                    }
                }
                log.error("\u9519\u8bef: \u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 {} \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", (Object)this.repositoryProperties.getUserConnectionTableName());
                throw new Exception(String.format("\u521d\u59cb\u5316\u7b2c\u4e09\u65b9\u767b\u5f55\u7684 %s \u7528\u6237\u8868\u65f6\u53d1\u751f\u9519\u8bef", this.repositoryProperties.getUserConnectionTableName()));
            }
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-user-connection-and-auth-token-table"}, havingValue="true")
    static class AuthTokenAutoConfiguration {
        private final RepositoryProperties repositoryProperties;

        public AuthTokenAutoConfiguration(RepositoryProperties repositoryProperties) {
            this.repositoryProperties = repositoryProperties;
        }

        @Bean
        @ConditionalOnMissingBean(type={"top.dcenter.ums.security.core.oauth.repository.UsersConnectionTokenRepository"})
        @ConditionalOnProperty(prefix="ums.oauth", name={"enable-auth-token-table"}, havingValue="true")
        public UsersConnectionTokenRepository usersConnectionTokenRepository(@Qualifier(value="connectionTextEncryptor") TextEncryptor connectionTextEncryptor, JdbcTemplate auth2UserConnectionJdbcTemplate) {
            return new Auth2JdbcUsersConnectionTokenRepository(auth2UserConnectionJdbcTemplate, connectionTextEncryptor, this.repositoryProperties.getAuthTokenTableName());
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="ums.oauth", name={"enable-user-connection-and-auth-token-table"}, havingValue="true")
    static class JobAutoConfiguration {
        private final Auth2Properties auth2Properties;

        public JobAutoConfiguration(Auth2Properties auth2Properties) {
            this.auth2Properties = auth2Properties;
        }

        @Bean
        @ConditionalOnProperty(prefix="ums.oauth", name={"enable-refresh-token-job"}, havingValue="true")
        public RefreshTokenJob refreshTokenJob(@Autowired(required=false) UsersConnectionTokenRepository usersConnectionTokenRepository, UsersConnectionRepository usersConnectionRepository, @Qualifier(value="refreshTokenTaskExecutor") ExecutorService refreshTokenTaskExecutor) {
            return new RefreshTokenJobImpl(usersConnectionRepository, usersConnectionTokenRepository, this.auth2Properties, refreshTokenTaskExecutor);
        }
    }
}

