/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.oneclicklogin;

import java.util.Map;
import java.util.Objects;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import top.dcenter.ums.security.core.oauth.oneclicklogin.OneClickLoginAuthenticationToken;
import top.dcenter.ums.security.core.oauth.oneclicklogin.service.OneClickLoginService;
import top.dcenter.ums.security.core.oauth.service.UmsUserDetailsService;

public class OneClickLoginAuthenticationProvider
implements AuthenticationProvider {
    private final UmsUserDetailsService userDetailsService;
    private final OneClickLoginService oneClickLoginService;

    public OneClickLoginAuthenticationProvider(UmsUserDetailsService userDetailsService, OneClickLoginService oneClickLoginService) {
        this.userDetailsService = userDetailsService;
        this.oneClickLoginService = oneClickLoginService;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        UserDetails user;
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        OneClickLoginAuthenticationToken authenticationToken = (OneClickLoginAuthenticationToken)authentication;
        if (authentication.isAuthenticated()) {
            return authentication;
        }
        try {
            user = this.userDetailsService.loadUserByUsername((String)authenticationToken.getPrincipal());
        }
        catch (UsernameNotFoundException e) {
            user = null;
        }
        Map<String, String> otherParamMap = null;
        if (user == null) {
            user = this.userDetailsService.registerUser((String)authenticationToken.getPrincipal());
        }
        if (Objects.nonNull(otherParamMap = authenticationToken.getOtherParamMap()) && !otherParamMap.isEmpty()) {
            this.oneClickLoginService.otherParamsHandler(user, otherParamMap);
        }
        OneClickLoginAuthenticationToken authenticationResult = new OneClickLoginAuthenticationToken(user, otherParamMap, user.getAuthorities());
        authenticationResult.setDetails(authenticationToken.getDetails());
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return OneClickLoginAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

