/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.util.StringUtils;
import top.dcenter.ums.security.core.oauth.jackson.deserializes.SimpleGrantedAuthorityMixin;

public final class MvcUtil {
    private static final Logger log = LoggerFactory.getLogger(MvcUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String HEADER_X_REQUESTED_WITH_NAME = "X-Requested-With";
    public static final String X_REQUESTED_WITH = "XMLHttpRequest";
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    private MvcUtil() {
    }

    public static String toJsonString(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            String msg = String.format("Object2JsonString \u5931\u8d25: %s, Object=%s", e.getMessage(), obj);
            log.error(msg, (Throwable)e);
            return "";
        }
    }

    @Nullable
    public static <T> T json2Object(@NonNull String jsonString, @NonNull Class<T> clz) {
        try {
            return (T)OBJECT_MAPPER.readValue(jsonString, clz);
        }
        catch (JsonProcessingException e) {
            log.error(String.format("[%s] \u53cd\u5e8f\u5217\u5316\u4e3a [%s] \u65f6\u9519\u8bef: %s", jsonString, clz.getName(), e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public static boolean isAjaxOrJson(HttpServletRequest request) {
        String xRequestedWith = request.getHeader(HEADER_X_REQUESTED_WITH_NAME);
        String accept = request.getHeader("accept");
        return StringUtils.hasText((String)accept) && accept.contains("application/json") || xRequestedWith != null && xRequestedWith.equalsIgnoreCase(X_REQUESTED_WITH);
    }

    public static void responseWithJson(HttpServletResponse response, int status, String result) throws IOException {
        if (!response.isCommitted()) {
            response.setStatus(status);
            response.setContentType("application/json");
            response.setCharacterEncoding("UTF-8");
            PrintWriter writer = response.getWriter();
            writer.write(result);
            writer.flush();
        }
    }

    public static String[] splitByCharacterTypeCamelCase(String str, boolean camelCase) {
        if (str == null) {
            return null;
        }
        if (str.isEmpty()) {
            return new String[0];
        }
        char[] c = str.toCharArray();
        ArrayList<String> list = new ArrayList<String>();
        int tokenStart = 0;
        int currentType = Character.getType(c[tokenStart]);
        for (int pos = tokenStart + 1; pos < c.length; ++pos) {
            int type = Character.getType(c[pos]);
            if (type == currentType) continue;
            if (camelCase && type == 2 && currentType == 1) {
                int newTokenStart = pos - 1;
                if (newTokenStart != tokenStart) {
                    list.add(new String(c, tokenStart, newTokenStart - tokenStart));
                    tokenStart = newTokenStart;
                }
            } else {
                list.add(new String(c, tokenStart, pos - tokenStart));
                tokenStart = pos;
            }
            currentType = type;
        }
        list.add(new String(c, tokenStart, c.length - tokenStart));
        return list.toArray(new String[0]);
    }

    public static byte[] readAllBytes(InputStream inputStream) throws IOException {
        return MvcUtil.readNBytes(Integer.MAX_VALUE, inputStream);
    }

    private static byte[] readNBytes(int len, InputStream inputStream) throws IOException {
        int n;
        if (len < 0) {
            throw new IllegalArgumentException("len < 0");
        }
        ArrayList<byte[]> bufs = null;
        byte[] result = null;
        int total = 0;
        int remaining = len;
        do {
            byte[] buf = new byte[Math.min(remaining, 8192)];
            int nread = 0;
            while ((n = inputStream.read(buf, nread, Math.min(buf.length - nread, remaining))) > 0) {
                nread += n;
                remaining -= n;
            }
            if (nread <= 0) continue;
            if (0x7FFFFFF7 - total < nread) {
                throw new OutOfMemoryError("Required array size too large");
            }
            total += nread;
            if (result == null) {
                result = buf;
                continue;
            }
            if (bufs == null) {
                bufs = new ArrayList<byte[]>();
                bufs.add(result);
            }
            bufs.add(buf);
        } while (n >= 0 && remaining > 0);
        if (bufs == null) {
            if (result == null) {
                return new byte[0];
            }
            return result.length == total ? result : Arrays.copyOf(result, total);
        }
        result = new byte[total];
        int offset = 0;
        remaining = total;
        for (byte[] b : bufs) {
            int count = Math.min(b.length, remaining);
            System.arraycopy(b, 0, result, offset, count);
            offset += count;
            remaining -= count;
        }
        return result;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        OBJECT_MAPPER.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        OBJECT_MAPPER.addMixIn(SimpleGrantedAuthority.class, SimpleGrantedAuthorityMixin.class);
        OBJECT_MAPPER.registerModule((Module)new JavaTimeModule());
    }
}

