/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.tasks.config;

import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.tasks.config.TasksAutoConfiguration;
import top.dcenter.ums.security.core.tasks.handler.RefreshAccessTokenJobHandler;

@Configuration
@AutoConfigureAfter(value={TasksAutoConfiguration.class})
@EnableScheduling
public class ScheduleAutoConfiguration
implements SchedulingConfigurer {
    private final ScheduledExecutorService jobTaskScheduledExecutor;
    private final Auth2Properties auth2Properties;
    private final RefreshAccessTokenJobHandler refreshAccessTokenJobHandler;

    public ScheduleAutoConfiguration(@Qualifier(value="jobTaskScheduledExecutor") ScheduledExecutorService jobTaskScheduledExecutor, Auth2Properties auth2Properties, @Autowired(required=false) RefreshAccessTokenJobHandler refreshAccessTokenJobHandler) {
        this.jobTaskScheduledExecutor = jobTaskScheduledExecutor;
        this.auth2Properties = auth2Properties;
        this.refreshAccessTokenJobHandler = refreshAccessTokenJobHandler;
    }

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.jobTaskScheduledExecutor);
        if (this.refreshAccessTokenJobHandler != null) {
            taskRegistrar.addCronTask(this.refreshAccessTokenJobHandler::refreshAccessTokenJob, this.auth2Properties.getRefreshTokenJobCron());
        }
    }
}

