/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableFunction;
import schemacrawler.crawl.MutableFunctionParameter;
import schemacrawler.crawl.MutableRoutine;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.DataTypeType;
import schemacrawler.schema.FunctionParameter;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schema.ParameterModeType;
import schemacrawler.schema.RoutineType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import schemacrawler.schemacrawler.SchemaInfoMetadataRetrievalStrategy;
import us.fatehi.utility.Utility;
import us.fatehi.utility.string.StringFormat;

final class FunctionParameterRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(FunctionParameterRetriever.class.getName());

    FunctionParameterRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) {
        super(retrieverConnection, catalog, options);
    }

    void retrieveFunctionParameters(NamedObjectList<MutableRoutine> allRoutines, InclusionRule parameterInclusionRule) throws SQLException {
        Objects.requireNonNull(allRoutines, "No functions provided");
        InclusionRuleFilter<FunctionParameter> parameterFilter = new InclusionRuleFilter<FunctionParameter>(parameterInclusionRule, true);
        if (parameterFilter.isExcludeAll()) {
            LOGGER.log(Level.INFO, "Not retrieving function parameters, since this was not requested");
            return;
        }
        switch (this.getRetrieverConnection().get(SchemaInfoMetadataRetrievalStrategy.functionParametersRetrievalStrategy)) {
            case data_dictionary_all: {
                LOGGER.log(Level.INFO, "Retrieving function parameters, using fast data dictionary retrieval");
                this.retrieveFunctionParametersFromDataDictionary(allRoutines, parameterFilter);
                break;
            }
            case metadata: {
                LOGGER.log(Level.INFO, "Retrieving function parameters");
                this.retrieveFunctionParametersFromMetadata(allRoutines, parameterFilter);
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Not retrieving function parameters");
            }
        }
    }

    private void createFunctionParameter(MetadataResultSet results, NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionParameter> parameterFilter) {
        String columnCatalogName = this.normalizeCatalogName(results.getString("FUNCTION_CAT"));
        String schemaName = this.normalizeSchemaName(results.getString("FUNCTION_SCHEM"));
        String functionName = results.getString("FUNCTION_NAME");
        String columnName = results.getString("COLUMN_NAME");
        String specificName = results.getString("SPECIFIC_NAME");
        ParameterModeType parameterMode = this.getFunctionParameterMode(results.getInt("COLUMN_TYPE", 0));
        LOGGER.log(Level.FINE, new StringFormat("Retrieving function column <%s.%s.%s.%s.%s>", columnCatalogName, schemaName, functionName, specificName, columnName));
        if (Utility.isBlank(columnName) && parameterMode == ParameterModeType.result) {
            columnName = "<return value>";
        }
        if (Utility.isBlank(columnName)) {
            return;
        }
        Optional<MutableRoutine> optionalRoutine = allRoutines.lookup(new NamedObjectKey(columnCatalogName, schemaName, functionName, specificName));
        if (!optionalRoutine.isPresent()) {
            return;
        }
        MutableRoutine routine = optionalRoutine.get();
        if (routine.getRoutineType() != RoutineType.function) {
            return;
        }
        MutableFunction function = (MutableFunction)routine;
        MutableFunctionParameter parameter = this.lookupOrCreateFunctionParameter(function, columnName);
        if (parameterFilter.test(parameter) && this.belongsToSchema(function, columnCatalogName, schemaName)) {
            int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
            int dataType = results.getInt("DATA_TYPE", 0);
            String typeName = results.getString("TYPE_NAME");
            int length = results.getInt("LENGTH", 0);
            int precision = results.getInt("PRECISION", 0);
            boolean isNullable = results.getShort("NULLABLE", (short)2) == 1;
            String remarks = results.getString("REMARKS");
            parameter.setOrdinalPosition(ordinalPosition);
            parameter.setParameterMode(parameterMode);
            parameter.setColumnDataType(this.lookupOrCreateColumnDataType(DataTypeType.user_defined, function.getSchema(), dataType, typeName));
            parameter.setSize(length);
            parameter.setPrecision(precision);
            parameter.setNullable(isNullable);
            parameter.setRemarks(remarks);
            parameter.addAttributes(results.getAttributes());
            LOGGER.log(Level.FINER, new StringFormat("Adding parameter to function <%s>", parameter));
            function.addParameter(parameter);
        }
    }

    private ParameterModeType getFunctionParameterMode(int columnType) {
        switch (columnType) {
            case 1: {
                return ParameterModeType.in;
            }
            case 2: {
                return ParameterModeType.inOut;
            }
            case 3: {
                return ParameterModeType.out;
            }
            case 5: {
                return ParameterModeType.result;
            }
            case 4: {
                return ParameterModeType.returnValue;
            }
        }
        return ParameterModeType.unknown;
    }

    private MutableFunctionParameter lookupOrCreateFunctionParameter(MutableFunction function, String columnName) {
        Optional<MutableFunctionParameter> columnOptional = function.lookupParameter(columnName);
        MutableFunctionParameter column = columnOptional.orElseGet(() -> new MutableFunctionParameter(function, columnName));
        return column;
    }

    private void retrieveFunctionParametersFromDataDictionary(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionParameter> parameterFilter) throws SQLException {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.FUNCTION_COLUMNS)) {
            throw new SchemaCrawlerSQLException("No function columns SQL provided", null);
        }
        Query functionColumnsSql = informationSchemaViews.getQuery(InformationSchemaKey.FUNCTION_COLUMNS);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(functionColumnsSql, statement, this.getSchemaInclusionRule());){
            results.setDescription("retrieveFunctionColumnsFromDataDictionary");
            while (results.next()) {
                this.createFunctionParameter(results, allRoutines, parameterFilter);
            }
        }
    }

    private void retrieveFunctionParametersFromMetadata(NamedObjectList<MutableRoutine> allRoutines, InclusionRuleFilter<FunctionParameter> parameterFilter) {
        for (MutableRoutine routine : allRoutines) {
            if (routine.getRoutineType() != RoutineType.function) continue;
            MutableFunction function = (MutableFunction)routine;
            LOGGER.log(Level.FINE, "Retrieving function parameters for " + function);
            try {
                MetadataResultSet results = new MetadataResultSet(this.getMetaData().getFunctionColumns(function.getSchema().getCatalogName(), function.getSchema().getName(), function.getName(), null));
                Throwable throwable = null;
                try {
                    while (results.next()) {
                        this.createFunctionParameter(results, allRoutines, parameterFilter);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (results == null) continue;
                    if (throwable != null) {
                        try {
                            results.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    results.close();
                }
            }
            catch (AbstractMethodError | SQLFeatureNotSupportedException e) {
                this.logSQLFeatureNotSupported(new StringFormat("Could not retrieve parameters for function %s", function), e);
            }
            catch (SQLException e) {
                this.logPossiblyUnsupportedSQLFeature(new StringFormat("Could not retrieve parameters for function %s", function), e);
            }
        }
    }
}

