/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.ResultsRetriever;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.SchemaCrawlerSQLException;
import us.fatehi.utility.StopWatch;

public final class ResultsCrawler {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(ResultsCrawler.class.getName());
    private final ResultSet results;

    public ResultsCrawler(ResultSet results) {
        this.results = Objects.requireNonNull(results, "No result-set specified");
    }

    public ResultsColumns crawl() throws SQLException {
        StopWatch stopWatch = new StopWatch("crawlResultSet");
        LOGGER.log(Level.INFO, "Crawling result set");
        try {
            ResultsRetriever resultsRetriever = new ResultsRetriever(this.results);
            ResultsColumns resultsColumns = stopWatch.time("retrieveResults", resultsRetriever::retrieveResults);
            LOGGER.log(Level.INFO, stopWatch.stringify());
            return resultsColumns;
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SchemaCrawlerSQLException("Could not retrieve result-set metadata", e);
        }
    }
}

