/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.MutableColumn;
import schemacrawler.crawl.MutablePrimaryKey;
import schemacrawler.crawl.MutableTable;
import schemacrawler.crawl.MutableTableConstraint;
import schemacrawler.crawl.MutableTableConstraintColumn;
import schemacrawler.crawl.NamedObjectList;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.schema.ForeignKey;
import schemacrawler.schema.Schema;
import schemacrawler.schema.TableConstraint;
import schemacrawler.schema.TableConstraintType;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import us.fatehi.utility.string.StringFormat;

final class TableConstraintRetriever
extends AbstractRetriever {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableConstraintRetriever.class.getName());
    private final Map<List<String>, MutableTableConstraint> tableConstraintsMap = new HashMap<List<String>, MutableTableConstraint>();

    TableConstraintRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
    }

    public void matchTableConstraints(NamedObjectList<MutableTable> allTables) {
        Objects.requireNonNull(allTables, "No tables provided");
        for (MutableTable mutableTable : allTables) {
            if (mutableTable == null) continue;
            this.matchPrimaryKey(mutableTable);
            this.addImportedForeignKeys(mutableTable);
        }
    }

    void retrieveTableConstraintDefinitions() {
        if (this.tableConstraintsMap.isEmpty()) {
            LOGGER.log(Level.FINE, "No table constraints found");
            return;
        }
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.CHECK_CONSTRAINTS)) {
            LOGGER.log(Level.FINE, "Extended table constraints SQL statement was not provided");
            return;
        }
        Query extTableConstraintInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.CHECK_CONSTRAINTS);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(extTableConstraintInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = results.getString("CONSTRAINT_NAME");
                LOGGER.log(Level.FINER, new StringFormat("Retrieving definition for constraint <%s>", constraintName));
                String definition = results.getString("CHECK_CLAUSE");
                MutableTableConstraint tableConstraint = this.tableConstraintsMap.get(Arrays.asList(catalogName, schemaName, constraintName));
                if (tableConstraint == null) {
                    LOGGER.log(Level.FINEST, new StringFormat("Could not add table constraint <%s>", constraintName));
                    continue;
                }
                tableConstraint.appendDefinition(definition);
                tableConstraint.addAttributes(results.getAttributes());
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", (Throwable)e);
        }
    }

    void retrieveTableConstraintInformation() {
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        this.createTableConstraints(this.tableConstraintsMap, informationSchemaViews);
        if (!this.tableConstraintsMap.isEmpty()) {
            this.retrieveTableConstraintsColumns(this.tableConstraintsMap, informationSchemaViews);
        }
    }

    private void addImportedForeignKeys(MutableTable mutableTable) {
        Collection<ForeignKey> importedForeignKeys = mutableTable.getImportedForeignKeys();
        for (ForeignKey foreignKey : importedForeignKeys) {
            mutableTable.addTableConstraint(foreignKey);
        }
    }

    private void createTableConstraints(Map<List<String>, MutableTableConstraint> tableConstraintsMap, InformationSchemaViews informationSchemaViews) {
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.TABLE_CONSTRAINTS)) {
            LOGGER.log(Level.FINE, "Table constraints SQL statement was not provided");
            return;
        }
        Query tableConstraintsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.TABLE_CONSTRAINTS);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableConstraintsInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = results.getString("CONSTRAINT_NAME");
                LOGGER.log(Level.FINER, new StringFormat("Retrieving constraint <%s>", constraintName));
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
                    continue;
                }
                MutableTable table = tableOptional.get();
                String constraintType = results.getString("CONSTRAINT_TYPE");
                boolean deferrable = results.getBoolean("IS_DEFERRABLE");
                boolean initiallyDeferred = results.getBoolean("INITIALLY_DEFERRED");
                MutableTableConstraint tableConstraint = new MutableTableConstraint(table, constraintName);
                tableConstraint.setTableConstraintType(TableConstraintType.valueOfFromValue(constraintType));
                tableConstraint.setDeferrable(deferrable);
                tableConstraint.setInitiallyDeferred(initiallyDeferred);
                tableConstraint.addAttributes(results.getAttributes());
                table.addTableConstraint(tableConstraint);
                Schema schema = table.getSchema();
                tableConstraintsMap.put(Arrays.asList(schema.getCatalogName(), schema.getName(), constraintName), tableConstraint);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve table constraint information", (Throwable)e);
            return;
        }
    }

    private void matchPrimaryKey(MutableTable mutableTable) {
        if (!mutableTable.hasPrimaryKey()) {
            return;
        }
        MutablePrimaryKey primaryKey = mutableTable.getPrimaryKey();
        for (TableConstraint tableConstraint : mutableTable.getTableConstraints()) {
            if (tableConstraint.getType() != TableConstraintType.primary_key || !primaryKey.getName().equals(tableConstraint.getName()) && !primaryKey.getConstrainedColumns().equals(tableConstraint.getConstrainedColumns())) continue;
            if (!primaryKey.hasRemarks() && tableConstraint.hasRemarks()) {
                primaryKey.setRemarks(tableConstraint.getRemarks());
            }
            for (Map.Entry<String, Object> attribute : tableConstraint.getAttributes().entrySet()) {
                primaryKey.setAttribute(attribute.getKey(), attribute.getValue());
            }
            mutableTable.removeTableConstraint(tableConstraint);
        }
        mutableTable.addTableConstraint(primaryKey);
    }

    private void retrieveTableConstraintsColumns(Map<List<String>, MutableTableConstraint> tableConstraintsMap, InformationSchemaViews informationSchemaViews) {
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE)) {
            LOGGER.log(Level.FINE, "Table constraints columns usage SQL statement was not provided");
            return;
        }
        Query tableConstraintsColumnsInformationSql = informationSchemaViews.getQuery(InformationSchemaKey.CONSTRAINT_COLUMN_USAGE);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(tableConstraintsColumnsInformationSql, statement, this.getSchemaInclusionRule());){
            while (results.next()) {
                String columnName;
                String catalogName = this.normalizeCatalogName(results.getString("CONSTRAINT_CATALOG"));
                String schemaName = this.normalizeSchemaName(results.getString("CONSTRAINT_SCHEMA"));
                String constraintName = results.getString("CONSTRAINT_NAME");
                LOGGER.log(Level.FINER, new StringFormat("Retrieving definition for constraint <%s>", constraintName));
                MutableTableConstraint tableConstraint = tableConstraintsMap.get(Arrays.asList(catalogName, schemaName, constraintName));
                if (tableConstraint == null) {
                    LOGGER.log(Level.FINEST, new StringFormat("Could not add column constraint <%s>", constraintName));
                    continue;
                }
                String tableName = results.getString("TABLE_NAME");
                Optional<MutableTable> tableOptional = this.lookupTable(catalogName, schemaName, tableName);
                if (!tableOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find table <%s.%s.%s>", catalogName, schemaName, tableName));
                    continue;
                }
                MutableTable table = tableOptional.get();
                Optional<MutableColumn> columnOptional = table.lookupColumn(columnName = results.getString("COLUMN_NAME"));
                if (!columnOptional.isPresent()) {
                    LOGGER.log(Level.FINE, new StringFormat("Cannot find column <%s.%s.%s.%s>", catalogName, schemaName, tableName, columnName));
                    continue;
                }
                MutableColumn column = columnOptional.get();
                int ordinalPosition = results.getInt("ORDINAL_POSITION", 0);
                MutableTableConstraintColumn constraintColumn = new MutableTableConstraintColumn(tableConstraint, column);
                constraintColumn.setKeyOrdinalPosition(ordinalPosition);
                tableConstraint.addColumn(constraintColumn);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve check constraints", (Throwable)e);
        }
    }
}

