/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Column;
import schemacrawler.schema.Table;
import schemacrawler.schema.Trigger;
import schemacrawler.schemacrawler.GrepOptions;
import us.fatehi.utility.string.StringFormat;

class TableGrepFilter
implements Predicate<Table> {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(TableGrepFilter.class.getName());
    private final InclusionRule grepTableInclusionRule;
    private final InclusionRule grepColumnInclusionRule;
    private final InclusionRule grepDefinitionInclusionRule;
    private final boolean invertMatch;

    public TableGrepFilter(GrepOptions options) {
        Objects.requireNonNull(options, "No grep options provided");
        this.invertMatch = options.isGrepInvertMatch();
        this.grepTableInclusionRule = options.getGrepTableInclusionRule().orElse(null);
        this.grepColumnInclusionRule = options.getGrepColumnInclusionRule().orElse(null);
        this.grepDefinitionInclusionRule = options.getGrepDefinitionInclusionRule().orElse(null);
    }

    @Override
    public boolean test(Table table) {
        boolean include;
        List<Column> columns;
        boolean checkIncludeForDefinitions;
        boolean checkIncludeForTables = this.grepTableInclusionRule != null;
        boolean checkIncludeForColumns = this.grepColumnInclusionRule != null;
        boolean bl = checkIncludeForDefinitions = this.grepDefinitionInclusionRule != null;
        if (!(checkIncludeForTables || checkIncludeForColumns || checkIncludeForDefinitions)) {
            return true;
        }
        boolean includeForTables = false;
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        if (checkIncludeForTables && this.grepTableInclusionRule.test(table.getFullName())) {
            includeForTables = true;
        }
        if ((columns = table.getColumns()).isEmpty()) {
            includeForColumns = true;
            includeForDefinitions = true;
        }
        for (Column column : columns) {
            if (checkIncludeForColumns && this.grepColumnInclusionRule.test(column.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !this.grepDefinitionInclusionRule.test(column.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (this.grepDefinitionInclusionRule.test(table.getRemarks())) {
                includeForDefinitions = true;
            }
            if (this.grepDefinitionInclusionRule.test(table.getDefinition())) {
                includeForDefinitions = true;
            }
            for (Trigger trigger : table.getTriggers()) {
                if (!this.grepDefinitionInclusionRule.test(trigger.getActionStatement())) continue;
                includeForDefinitions = true;
                break;
            }
        }
        boolean bl2 = include = checkIncludeForTables && includeForTables || checkIncludeForColumns && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.invertMatch) {
            boolean bl3 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, new StringFormat("Excluding table <%s>", table));
        }
        return include;
    }
}

