/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.catalogloader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.tools.catalogloader.CatalogLoader;
import schemacrawler.tools.catalogloader.ChainedCatalogLoader;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.commandline.PluginCommand;
import us.fatehi.utility.string.StringFormat;

public final class CatalogLoaderRegistry {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CatalogLoaderRegistry.class.getName());

    public Collection<PluginCommand> getCommandLineCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        try {
            for (CatalogLoader catalogLoader : this.loadCatalogLoaderRegistry()) {
                commandLineCommands.add(catalogLoader.getCommandLineCommand());
            }
        }
        catch (SchemaCrawlerException e) {
            throw new SchemaCrawlerRuntimeException("Could not load catalog loaders", e);
        }
        return commandLineCommands;
    }

    public Collection<PluginCommand> getHelpCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        try {
            for (CatalogLoader catalogLoader : this.loadCatalogLoaderRegistry()) {
                commandLineCommands.add(catalogLoader.getHelpCommand());
            }
        }
        catch (SchemaCrawlerException e) {
            throw new SchemaCrawlerRuntimeException("Could not load catalog loaders", e);
        }
        return commandLineCommands;
    }

    public Collection<CommandDescription> getSupportedCatalogLoaders() {
        HashSet<CommandDescription> commandLineCommands = new HashSet<CommandDescription>();
        try {
            for (CatalogLoader catalogLoader : this.loadCatalogLoaderRegistry()) {
                CommandDescription commandDescription = catalogLoader.getCommandDescription();
                commandLineCommands.add(new CommandDescription(commandDescription.getName(), commandDescription.getDescription()));
            }
        }
        catch (SchemaCrawlerException e) {
            throw new SchemaCrawlerRuntimeException("Could not load catalog loaders", e);
        }
        return commandLineCommands;
    }

    public ChainedCatalogLoader loadCatalogLoaders() throws SchemaCrawlerException {
        List<CatalogLoader> chainedCatalogLoaders = this.loadCatalogLoaderRegistry();
        return new ChainedCatalogLoader(chainedCatalogLoaders);
    }

    private List<CatalogLoader> loadCatalogLoaderRegistry() throws SchemaCrawlerException {
        ArrayList<CatalogLoader> catalogLoaderRegistry = new ArrayList<CatalogLoader>();
        try {
            ServiceLoader<CatalogLoader> serviceLoader = ServiceLoader.load(CatalogLoader.class);
            for (CatalogLoader catalogLoader : serviceLoader) {
                LOGGER.log(Level.CONFIG, new StringFormat("Loading catalog loader, %s", catalogLoader.getClass().getName()));
                catalogLoaderRegistry.add(catalogLoader);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load catalog loader registry", e);
        }
        Collections.sort(catalogLoaderRegistry);
        return catalogLoaderRegistry;
    }
}

