/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.command.text.diagram;

import java.nio.file.Path;
import java.util.List;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.tools.command.text.diagram.GraphExecutor;
import schemacrawler.tools.command.text.diagram.GraphNoOpExecutor;
import schemacrawler.tools.command.text.diagram.GraphvizJavaExecutor;
import schemacrawler.tools.command.text.diagram.GraphvizProcessExecutor;
import schemacrawler.tools.command.text.diagram.GraphvizUtility;
import schemacrawler.tools.command.text.diagram.options.DiagramOptions;
import schemacrawler.tools.command.text.diagram.options.DiagramOutputFormat;
import us.fatehi.utility.IOUtility;

public class GraphExecutorFactory {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(GraphExecutorFactory.class.getName());

    public void canGenerate(DiagramOutputFormat diagramOutputFormat) throws Exception {
        if (diagramOutputFormat == null) {
            throw new SchemaCrawlerException("No diagram output format specified");
        }
        if (diagramOutputFormat == DiagramOutputFormat.scdot) {
            return;
        }
        if (GraphvizUtility.isGraphvizAvailable()) {
            return;
        }
        if (GraphvizUtility.isGraphvizJavaAvailable(diagramOutputFormat)) {
            return;
        }
        throw new SchemaCrawlerException(String.format("Cannot generate diagram in %s output format", diagramOutputFormat));
    }

    public GraphExecutor getGraphExecutor(Path dotFile, DiagramOutputFormat diagramOutputFormat, Path outputFile, DiagramOptions commandOptions) throws SchemaCrawlerException {
        GraphExecutor graphExecutor;
        if (diagramOutputFormat != DiagramOutputFormat.scdot) {
            List<String> graphvizOpts = commandOptions.getGraphvizOpts();
            boolean graphExecutorAvailable = false;
            graphExecutor = new GraphvizProcessExecutor(dotFile, outputFile, diagramOutputFormat, graphvizOpts);
            graphExecutorAvailable = graphExecutor.canGenerate();
            if (!graphExecutorAvailable) {
                graphExecutor = new GraphvizJavaExecutor(dotFile, outputFile, diagramOutputFormat);
                graphExecutorAvailable = graphExecutor.canGenerate();
            }
            if (!graphExecutorAvailable) {
                String message = IOUtility.readResourceFully("/dot.error.txt");
                throw new SchemaCrawlerRuntimeException(message);
            }
        } else {
            graphExecutor = new GraphNoOpExecutor(diagramOutputFormat);
        }
        LOGGER.log(Level.INFO, "Using " + graphExecutor);
        return graphExecutor;
    }
}

