/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.executable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaCrawlerRuntimeException;
import schemacrawler.tools.executable.CommandDescription;
import schemacrawler.tools.executable.CommandProvider;
import schemacrawler.tools.executable.SchemaCrawlerCommand;
import schemacrawler.tools.executable.commandline.PluginCommand;
import schemacrawler.tools.options.Config;
import schemacrawler.tools.options.OutputOptions;
import us.fatehi.utility.string.StringFormat;

public final class CommandRegistry {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(CommandRegistry.class.getName());
    private static CommandRegistry commandRegistrySingleton;
    private final List<CommandProvider> commandRegistry = CommandRegistry.loadCommandRegistry();

    public static CommandRegistry getCommandRegistry() {
        try {
            if (commandRegistrySingleton == null) {
                commandRegistrySingleton = new CommandRegistry();
            }
        }
        catch (SchemaCrawlerException e) {
            throw new SchemaCrawlerRuntimeException("Cannot load SchemaCrawler commands", e);
        }
        return commandRegistrySingleton;
    }

    private static List<CommandProvider> loadCommandRegistry() throws SchemaCrawlerException {
        ArrayList<CommandProvider> commandProviders = new ArrayList<CommandProvider>();
        try {
            ServiceLoader<CommandProvider> serviceLoader = ServiceLoader.load(CommandProvider.class);
            for (CommandProvider commandProvider : serviceLoader) {
                LOGGER.log(Level.CONFIG, new StringFormat("Loading command %s, provided by %s", commandProvider.getSupportedCommands(), commandProvider.getClass().getName()));
                commandProviders.add(commandProvider);
            }
        }
        catch (Exception e) {
            throw new SchemaCrawlerException("Could not load extended command registry", e);
        }
        return commandProviders;
    }

    private CommandRegistry() throws SchemaCrawlerException {
    }

    public SchemaCrawlerCommand<?> configureNewCommand(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions) throws SchemaCrawlerException {
        SchemaCrawlerCommand<?> scCommand;
        ArrayList<CommandProvider> executableCommandProviders = new ArrayList<CommandProvider>();
        this.findSupportedCommands(command, schemaCrawlerOptions, additionalConfig, outputOptions, executableCommandProviders);
        this.findSupportedOutputFormats(command, outputOptions, executableCommandProviders);
        Collections.sort(executableCommandProviders, (commandProvider1, commandProvider2) -> {
            String typeName2;
            if (commandProvider1 == null || commandProvider2 == null) {
                throw new IllegalArgumentException("Null command provider found");
            }
            String typeName1 = commandProvider1.getClass().getSimpleName();
            if (typeName1.equals(typeName2 = commandProvider2.getClass().getSimpleName())) {
                return 0;
            }
            if (typeName1.equals("OperationCommandProvider")) {
                return 1;
            }
            if (typeName2.equals("OperationCommandProvider")) {
                return -1;
            }
            return typeName1.compareTo(typeName2);
        });
        CommandProvider executableCommandProvider = (CommandProvider)executableCommandProviders.get(0);
        LOGGER.log(Level.INFO, new StringFormat("Matched provider <%s>", executableCommandProvider));
        try {
            scCommand = executableCommandProvider.newSchemaCrawlerCommand(command, additionalConfig);
            scCommand.setSchemaCrawlerOptions(schemaCrawlerOptions);
            scCommand.setOutputOptions(outputOptions);
        }
        catch (Throwable e) {
            LOGGER.log(Level.CONFIG, e.getMessage(), e);
            throw new SchemaCrawlerRuntimeException(String.format("Cannot run command <%s>", command));
        }
        return scCommand;
    }

    public Collection<PluginCommand> getCommandLineCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            commandLineCommands.add(commandProvider.getCommandLineCommand());
        }
        return commandLineCommands;
    }

    public Collection<PluginCommand> getHelpCommands() {
        HashSet<PluginCommand> commandLineCommands = new HashSet<PluginCommand>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            commandLineCommands.add(commandProvider.getHelpCommand());
        }
        return commandLineCommands;
    }

    public Collection<CommandDescription> getSupportedCommands() {
        HashSet<CommandDescription> supportedCommandDescriptions = new HashSet<CommandDescription>();
        for (CommandProvider commandProvider : this.commandRegistry) {
            supportedCommandDescriptions.addAll(commandProvider.getSupportedCommands());
        }
        ArrayList<CommandDescription> supportedCommandsOrdered = new ArrayList<CommandDescription>(supportedCommandDescriptions);
        supportedCommandsOrdered.sort(Comparator.naturalOrder());
        return supportedCommandsOrdered;
    }

    private void findSupportedCommands(String command, SchemaCrawlerOptions schemaCrawlerOptions, Config additionalConfig, OutputOptions outputOptions, List<CommandProvider> executableCommandProviders) throws SchemaCrawlerException {
        for (CommandProvider commandProvider : this.commandRegistry) {
            if (!commandProvider.supportsSchemaCrawlerCommand(command, schemaCrawlerOptions, additionalConfig, outputOptions)) continue;
            executableCommandProviders.add(commandProvider);
            LOGGER.log(Level.FINE, new StringFormat("Adding command-provider <%s>", commandProvider));
        }
        if (executableCommandProviders.isEmpty()) {
            throw new SchemaCrawlerException(String.format("Unknown command <%s>", command));
        }
    }

    private void findSupportedOutputFormats(String command, OutputOptions outputOptions, List<CommandProvider> executableCommandProviders) throws SchemaCrawlerException {
        Iterator<CommandProvider> iterator = executableCommandProviders.iterator();
        while (iterator.hasNext()) {
            CommandProvider executableCommandProvider = iterator.next();
            if (executableCommandProvider.supportsOutputFormat(command, outputOptions)) continue;
            LOGGER.log(Level.FINE, new StringFormat("Removing command-provider, since output format is not supported <%s>", executableCommandProvider));
            iterator.remove();
        }
        if (executableCommandProviders.isEmpty()) {
            throw new SchemaCrawlerException(String.format("Output format <%s> not supported for command <%s>", outputOptions.getOutputFormatValue(), command));
        }
    }
}

