/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.base;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Objects;
import java.util.logging.Level;
import schemacrawler.SchemaCrawlerLogger;
import schemacrawler.schema.Column;
import schemacrawler.schema.DatabaseObject;
import schemacrawler.schema.IndexColumn;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schemacrawler.Identifiers;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.options.OutputOptions;
import schemacrawler.tools.text.formatter.base.helper.HtmlFormattingHelper;
import schemacrawler.tools.text.formatter.base.helper.PlainTextFormattingHelper;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import schemacrawler.tools.text.options.BaseTextOptions;
import schemacrawler.tools.text.options.DatabaseObjectColorMap;
import schemacrawler.tools.traversal.TraversalHandler;
import us.fatehi.utility.Utility;

public abstract class BaseFormatter<O extends BaseTextOptions>
implements TraversalHandler {
    private static final SchemaCrawlerLogger LOGGER = SchemaCrawlerLogger.getLogger(BaseFormatter.class.getName());
    protected final O options;
    protected final OutputOptions outputOptions;
    protected final TextFormattingHelper formattingHelper;
    protected final DatabaseObjectColorMap colorMap;
    protected final Identifiers identifiers;
    protected final boolean printVerboseDatabaseInfo;
    private final PrintWriter out;

    protected BaseFormatter(O options, boolean printVerboseDatabaseInfo, OutputOptions outputOptions, String identifierQuoteString) throws SchemaCrawlerException {
        this.options = (BaseTextOptions)Objects.requireNonNull(options, "Options not provided");
        this.outputOptions = Objects.requireNonNull(outputOptions, "Output options not provided");
        this.colorMap = ((BaseTextOptions)options).getColorMap();
        this.printVerboseDatabaseInfo = !((BaseTextOptions)options).isNoInfo() && printVerboseDatabaseInfo;
        this.identifiers = Identifiers.identifiers().withIdentifierQuoteString(identifierQuoteString).withIdentifierQuotingStrategy(((BaseTextOptions)options).getIdentifierQuotingStrategy()).build();
        try {
            this.out = new PrintWriter(outputOptions.openNewOutputWriter(false), true);
        }
        catch (IOException e) {
            throw new SchemaCrawlerException("Cannot open output writer", e);
        }
        TextOutputFormat outputFormat = TextOutputFormat.fromFormat(outputOptions.getOutputFormatValue());
        switch (outputFormat) {
            case html: {
                this.formattingHelper = new HtmlFormattingHelper(this.out, outputFormat);
                break;
            }
            default: {
                this.formattingHelper = new PlainTextFormattingHelper(this.out, outputFormat);
            }
        }
    }

    @Override
    public void end() throws SchemaCrawlerException {
        LOGGER.log(Level.INFO, "Closing writer");
        this.out.flush();
        this.out.close();
    }

    protected String columnNullable(String columnTypeName, boolean isNullable) {
        String columnNullable = isNullable ? "" : (Utility.hasNoUpperCase(columnTypeName) ? " not null" : " NOT NULL");
        return columnNullable;
    }

    protected boolean isColumnSignificant(Column column) {
        return column != null && (column instanceof IndexColumn || column.isPartOfPrimaryKey() || column.isPartOfForeignKey() || column.isPartOfIndex());
    }

    protected String nodeId(DatabaseObject dbObject) {
        if (dbObject == null) {
            return "";
        }
        NamedObjectKey dbObjectLookupKey = dbObject.key();
        return Utility.convertForComparison(dbObject.getName()) + "_" + Integer.toHexString(dbObjectLookupKey.hashCode());
    }

    protected String quoteName(DatabaseObject table) {
        String tableName = ((BaseTextOptions)this.options).isShowUnqualifiedNames() ? this.identifiers.quoteName(table) : this.identifiers.quoteFullName(table);
        return tableName;
    }
}

