/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility.graph;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import us.fatehi.utility.graph.DirectedEdge;
import us.fatehi.utility.graph.Vertex;

public class DirectedGraph<T extends Comparable<? super T>> {
    private final Set<DirectedEdge<T>> edges;
    private final String name;
    private final Map<T, Vertex<T>> verticesMap;

    public DirectedGraph(String name) {
        this.name = name;
        this.verticesMap = new HashMap<T, Vertex<T>>();
        this.edges = new HashSet<DirectedEdge<T>>();
    }

    public void addEdge(T from, T to) {
        if (!from.equals(to)) {
            this.edges.add(new DirectedEdge<T>(this.addVertex(from), this.addVertex(to)));
        }
    }

    public Vertex<T> addVertex(T value) {
        Vertex<T> vertex;
        if (this.verticesMap.containsKey(value)) {
            vertex = this.verticesMap.get(value);
        } else {
            vertex = new Vertex<T>(value);
            this.verticesMap.put(value, vertex);
        }
        return vertex;
    }

    public Set<DirectedEdge<T>> edgeSet() {
        return new HashSet<DirectedEdge<T>>(this.edges);
    }

    public String getName() {
        return this.name;
    }

    public Set<DirectedEdge<T>> getOutgoingEdges(Vertex<T> vertexFrom) {
        Objects.requireNonNull(vertexFrom, "No vertex provided");
        HashSet<DirectedEdge<T>> outgoingEdges = new HashSet<DirectedEdge<T>>();
        for (DirectedEdge<T> edge : this.edges) {
            if (!edge.getFrom().equals(vertexFrom)) continue;
            outgoingEdges.add(edge);
        }
        return outgoingEdges;
    }

    public String toString() {
        StringBuilder writer = new StringBuilder(4096);
        writer.append("digraph {\n");
        if (this.name != null && !this.name.isEmpty()) {
            writer.append(String.format("  [label=\"%s\"]%n", this.name));
        }
        for (Vertex<T> vertex : this.verticesMap.values()) {
            writer.append("  ").append(vertex);
            if (vertex.hasAttribute("fillcolor")) {
                writer.append(String.format(" [fillcolor=%s, style=filled]", (Object[])vertex.getAttribute("fillcolor")));
            }
            writer.append(";\n");
        }
        for (DirectedEdge directedEdge : this.edges) {
            writer.append("  ").append(directedEdge).append(";\n");
        }
        writer.append("}\n");
        return writer.toString();
    }

    public Set<Vertex<T>> vertexSet() {
        return new HashSet<Vertex<T>>(this.verticesMap.values());
    }
}

