/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.model;

import java.util.Set;
import javax.annotation.Resource;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import xyz.erupt.annotation.fun.FilterHandler;
import xyz.erupt.core.config.EruptProp;
import xyz.erupt.core.exception.EruptApiErrorTip;
import xyz.erupt.core.view.EruptApiModel;
import xyz.erupt.monitor.model.EruptOnline;

@Service
public class EruptOnlineFilterHandler
implements FilterHandler {
    @Resource
    private EruptProp eruptProp;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    public String filter(String condition, String[] params) {
        if (this.eruptProp.isRedisSession()) {
            Set keys = this.stringRedisTemplate.keys((Object)"eruptAuth:token:*");
            if (keys != null && keys.size() > 0) {
                StringBuilder sb = new StringBuilder(EruptOnline.class.getSimpleName() + ".token in (");
                for (String key : keys) {
                    sb.append("'").append(key.substring("eruptAuth:token:".length())).append("',");
                }
                return sb.substring(0, sb.length() - 1) + ")";
            }
            return "1 = 2";
        }
        throw new EruptApiErrorTip(EruptApiModel.Status.INFO, "Enable the RedisSession configuration to use this feature", EruptApiModel.PromptWay.NOTIFY);
    }
}

