/*
 * Decompiled with CFR 0.152.
 */
package xyz.erupt.monitor.vo;

import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import xyz.erupt.monitor.util.SystemUtil;

public class Cpu {
    private int cpuNum;
    private String freq;
    private String sys;
    private String user;
    private String wait;
    private String usage;
    private String cpuModel;

    Cpu(SystemInfo systemInfo) {
        CentralProcessor processor = systemInfo.getHardware().getProcessor();
        long[] prevTicks = processor.getSystemCpuLoadTicks();
        TimeUnit.SECONDS.sleep(1L);
        long[] ticks = processor.getSystemCpuLoadTicks();
        long nice = ticks[CentralProcessor.TickType.NICE.getIndex()] - prevTicks[CentralProcessor.TickType.NICE.getIndex()];
        long irq = ticks[CentralProcessor.TickType.IRQ.getIndex()] - prevTicks[CentralProcessor.TickType.IRQ.getIndex()];
        long softirq = ticks[CentralProcessor.TickType.SOFTIRQ.getIndex()] - prevTicks[CentralProcessor.TickType.SOFTIRQ.getIndex()];
        long steal = ticks[CentralProcessor.TickType.STEAL.getIndex()] - prevTicks[CentralProcessor.TickType.STEAL.getIndex()];
        long cSys = ticks[CentralProcessor.TickType.SYSTEM.getIndex()] - prevTicks[CentralProcessor.TickType.SYSTEM.getIndex()];
        long user = ticks[CentralProcessor.TickType.USER.getIndex()] - prevTicks[CentralProcessor.TickType.USER.getIndex()];
        long iowait = ticks[CentralProcessor.TickType.IOWAIT.getIndex()] - prevTicks[CentralProcessor.TickType.IOWAIT.getIndex()];
        long idle = ticks[CentralProcessor.TickType.IDLE.getIndex()] - prevTicks[CentralProcessor.TickType.IDLE.getIndex()];
        long totalCpu = user + nice + cSys + idle + iowait + irq + softirq + steal;
        String freq = SystemUtil.formatByte(processor.getMaxFreq());
        this.setFreq(freq.substring(0, freq.length() - 1) + "Hz");
        this.setCpuNum(processor.getLogicalProcessorCount());
        this.setUser(new DecimalFormat("#.##%").format((double)user * 1.0 / (double)totalCpu));
        this.setSys(new DecimalFormat("#.##%").format((double)cSys * 1.0 / (double)totalCpu));
        this.setWait(new DecimalFormat("#.##%").format((double)iowait * 1.0 / (double)totalCpu));
        this.setUsage(new DecimalFormat("#.##%").format(1.0 - (double)idle * 1.0 / (double)totalCpu));
        this.setCpuModel(processor.toString());
    }

    public int getCpuNum() {
        return this.cpuNum;
    }

    public String getFreq() {
        return this.freq;
    }

    public String getSys() {
        return this.sys;
    }

    public String getUser() {
        return this.user;
    }

    public String getWait() {
        return this.wait;
    }

    public String getUsage() {
        return this.usage;
    }

    public String getCpuModel() {
        return this.cpuModel;
    }

    public void setCpuNum(int cpuNum) {
        this.cpuNum = cpuNum;
    }

    public void setFreq(String freq) {
        this.freq = freq;
    }

    public void setSys(String sys) {
        this.sys = sys;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setWait(String wait) {
        this.wait = wait;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public void setCpuModel(String cpuModel) {
        this.cpuModel = cpuModel;
    }
}

