/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.paddlepaddle.zoo.cv.objectdetection;

import ai.djl.modality.cv.Image;
import ai.djl.modality.cv.output.DetectedObjects;
import ai.djl.modality.cv.output.Rectangle;
import ai.djl.modality.cv.util.NDImageUtils;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.ndarray.types.Shape;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class PpFaceDetectionTranslator
implements Translator<Image, DetectedObjects> {
    private float shrink;
    private float threshold;
    private List<String> className;

    public PpFaceDetectionTranslator(Map<String, ?> arguments) {
        this.threshold = arguments.containsKey("threshold") ? (float)Double.parseDouble(arguments.get("threshold").toString()) : 0.7f;
        this.shrink = arguments.containsKey("shrink") ? (float)Double.parseDouble(arguments.get("shrink").toString()) : 0.5f;
        this.className = Arrays.asList("Not Face", "Face");
    }

    public NDList processInput(TranslatorContext ctx, Image input) {
        NDArray array = input.toNDArray(ctx.getNDManager());
        Shape shape = array.getShape();
        array = NDImageUtils.resize((NDArray)array, (int)((int)((float)shape.get(1) * this.shrink)), (int)((int)((float)shape.get(0) * this.shrink)));
        array = array.transpose(new int[]{2, 0, 1}).flip(new int[]{0});
        NDArray mean = ctx.getNDManager().create(new float[]{104.0f, 117.0f, 123.0f}, new Shape(new long[]{3L, 1L, 1L}));
        array = array.sub(mean).mul((Number)Float.valueOf(0.007843f));
        array = array.expandDims(0);
        return new NDList(new NDArray[]{array});
    }

    public DetectedObjects processOutput(TranslatorContext ctx, NDList list) throws Exception {
        NDArray result = list.singletonOrThrow();
        float[] probabilities = result.get(":,1", new Object[0]).toFloatArray();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<Double> prob = new ArrayList<Double>();
        ArrayList<Rectangle> boxes = new ArrayList<Rectangle>();
        for (int i = 0; i < probabilities.length; ++i) {
            if (!(probabilities[i] >= this.threshold)) continue;
            float[] array = result.get(new long[]{i}).toFloatArray();
            names.add(this.className.get((int)array[0]));
            prob.add(Double.valueOf(probabilities[i]));
            boxes.add(new Rectangle((double)array[2], (double)array[3], (double)(array[4] - array[2]), (double)(array[5] - array[3])));
        }
        return new DetectedObjects(names, prob, boxes);
    }

    public Batchifier getBatchifier() {
        return null;
    }
}

