/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage.platform;

import cn.hutool.core.util.StrUtil;
import cn.xuyanwu.spring.file.storage.FileInfo;
import cn.xuyanwu.spring.file.storage.UploadPretreatment;
import cn.xuyanwu.spring.file.storage.exception.FileStorageRuntimeException;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import com.qiniu.common.QiniuException;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.function.Consumer;

public class QiniuKodoFileStorage
implements FileStorage {
    private String platform;
    private String accessKey;
    private String secretKey;
    private String bucketName;
    private String domain;
    private String basePath;
    private Region region;
    private QiniuKodoClient client;

    public QiniuKodoClient getClient() {
        if (this.client == null) {
            this.client = new QiniuKodoClient(this.accessKey, this.secretKey);
        }
        return this.client;
    }

    @Override
    public void close() {
        this.client = null;
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        String newFileKey = this.basePath + fileInfo.getPath() + fileInfo.getFilename();
        fileInfo.setBasePath(this.basePath);
        fileInfo.setUrl(this.domain + newFileKey);
        try {
            QiniuKodoClient client = this.getClient();
            UploadManager uploadManager = client.getUploadManager();
            String token = client.getAuth().uploadToken(this.bucketName);
            uploadManager.put(pre.getFileWrapper().getInputStream(), newFileKey, token, null, fileInfo.getContentType());
            byte[] thumbnailBytes = pre.getThumbnailBytes();
            if (thumbnailBytes != null) {
                String newThFileKey = this.basePath + fileInfo.getPath() + fileInfo.getThFilename();
                fileInfo.setThUrl(this.domain + newThFileKey);
                uploadManager.put((InputStream)new ByteArrayInputStream(thumbnailBytes), newThFileKey, token, null, fileInfo.getThContentType());
            }
            return true;
        }
        catch (IOException e) {
            try {
                this.client.getBucketManager().delete(this.bucketName, newFileKey);
            }
            catch (QiniuException qiniuException) {
                // empty catch block
            }
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff01platform\uff1a" + this.platform + "\uff0cfilename\uff1a" + fileInfo.getOriginalFilename(), e);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        BucketManager manager = this.getClient().getBucketManager();
        try {
            if (fileInfo.getThFilename() != null) {
                manager.delete(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getThFilename());
            }
            manager.delete(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
        }
        catch (QiniuException e) {
            throw new FileStorageRuntimeException("\u5220\u9664\u6587\u4ef6\u5931\u8d25\uff01" + e.code() + "\uff0c" + e.response.toString(), e);
        }
        return true;
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        BucketManager manager = this.getClient().getBucketManager();
        try {
            com.qiniu.storage.model.FileInfo stat = manager.stat(this.bucketName, fileInfo.getBasePath() + fileInfo.getPath() + fileInfo.getFilename());
            if (stat != null && stat.md5 != null) {
                return true;
            }
        }
        catch (QiniuException e) {
            throw new FileStorageRuntimeException("\u67e5\u8be2\u6587\u4ef6\u662f\u5426\u5b58\u5728\u5931\u8d25\uff01" + e.code() + "\uff0c" + e.response.toString(), e);
        }
        return false;
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        String url = this.getClient().getAuth().privateDownloadUrl(fileInfo.getUrl());
        try (InputStream in = new URL(url).openStream();){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01platform\uff1a" + fileInfo, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThUrl())) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\uff01fileInfo\uff1a" + fileInfo);
        }
        String url = this.getClient().getAuth().privateDownloadUrl(fileInfo.getThUrl());
        try (InputStream in = new URL(url).openStream();){
            consumer.accept(in);
        }
        catch (IOException e) {
            throw new FileStorageRuntimeException("\u7f29\u7565\u56fe\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff01fileInfo\uff1a" + fileInfo, e);
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setRegion(Region region) {
        this.region = region;
    }

    public void setClient(QiniuKodoClient client) {
        this.client = client;
    }

    public static class QiniuKodoClient {
        private String accessKey;
        private String secretKey;
        private Auth auth;
        private BucketManager bucketManager;
        private UploadManager uploadManager;

        public QiniuKodoClient(String accessKey, String secretKey) {
            this.accessKey = accessKey;
            this.secretKey = secretKey;
        }

        public Auth getAuth() {
            if (this.auth == null) {
                this.auth = Auth.create((String)this.accessKey, (String)this.secretKey);
            }
            return this.auth;
        }

        public BucketManager getBucketManager() {
            if (this.bucketManager == null) {
                this.bucketManager = new BucketManager(this.getAuth(), new Configuration(Region.autoRegion()));
            }
            return this.bucketManager;
        }

        public UploadManager getUploadManager() {
            if (this.uploadManager == null) {
                this.uploadManager = new UploadManager(new Configuration(Region.autoRegion()));
            }
            return this.uploadManager;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public void setAuth(Auth auth) {
            this.auth = auth;
        }

        public void setBucketManager(BucketManager bucketManager) {
            this.bucketManager = bucketManager;
        }

        public void setUploadManager(UploadManager uploadManager) {
            this.uploadManager = uploadManager;
        }
    }
}

