/*
 * Decompiled with CFR 0.152.
 */
package cn.xuyanwu.spring.file.storage;

import cn.hutool.core.collection.CollUtil;
import cn.xuyanwu.spring.file.storage.FileStorageProperties;
import cn.xuyanwu.spring.file.storage.FileStorageService;
import cn.xuyanwu.spring.file.storage.aspect.FileStorageAspect;
import cn.xuyanwu.spring.file.storage.platform.AliyunOssFileStorage;
import cn.xuyanwu.spring.file.storage.platform.AwsS3FileStorage;
import cn.xuyanwu.spring.file.storage.platform.BaiduBosFileStorage;
import cn.xuyanwu.spring.file.storage.platform.FileStorage;
import cn.xuyanwu.spring.file.storage.platform.FtpFileStorage;
import cn.xuyanwu.spring.file.storage.platform.HuaweiObsFileStorage;
import cn.xuyanwu.spring.file.storage.platform.LocalFileStorage;
import cn.xuyanwu.spring.file.storage.platform.LocalPlusFileStorage;
import cn.xuyanwu.spring.file.storage.platform.MinIOFileStorage;
import cn.xuyanwu.spring.file.storage.platform.QiniuKodoFileStorage;
import cn.xuyanwu.spring.file.storage.platform.SftpFileStorage;
import cn.xuyanwu.spring.file.storage.platform.TencentCosFileStorage;
import cn.xuyanwu.spring.file.storage.platform.UpyunUssFileStorage;
import cn.xuyanwu.spring.file.storage.platform.WebDavFileStorage;
import cn.xuyanwu.spring.file.storage.recorder.DefaultFileRecorder;
import cn.xuyanwu.spring.file.storage.recorder.FileRecorder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ConditionalOnMissingBean(value={FileStorageService.class})
public class FileStorageAutoConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(FileStorageAutoConfiguration.class);
    @Autowired
    private FileStorageProperties properties;
    @Autowired
    private ApplicationContext applicationContext;

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        for (FileStorageProperties.Local local : this.properties.getLocal()) {
            if (!local.getEnableAccess().booleanValue()) continue;
            registry.addResourceHandler(local.getPathPatterns()).addResourceLocations(new String[]{"file:" + local.getBasePath()});
        }
        for (FileStorageProperties.LocalPlus localPlus : this.properties.getLocalPlus()) {
            if (!localPlus.getEnableAccess().booleanValue()) continue;
            registry.addResourceHandler(localPlus.getPathPatterns()).addResourceLocations(new String[]{"file:" + localPlus.getStoragePath()});
        }
    }

    @Bean
    public List<LocalFileStorage> localFileStorageList() {
        return this.properties.getLocal().stream().map(local -> {
            if (!local.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)local.getPlatform());
            LocalFileStorage localFileStorage = new LocalFileStorage();
            localFileStorage.setPlatform(local.getPlatform());
            localFileStorage.setBasePath(local.getBasePath());
            localFileStorage.setDomain(local.getDomain());
            return localFileStorage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    public List<LocalPlusFileStorage> localPlusFileStorageList() {
        return this.properties.getLocalPlus().stream().map(local -> {
            if (!local.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)local.getPlatform());
            LocalPlusFileStorage localFileStorage = new LocalPlusFileStorage();
            localFileStorage.setPlatform(local.getPlatform());
            localFileStorage.setBasePath(local.getBasePath());
            localFileStorage.setDomain(local.getDomain());
            localFileStorage.setStoragePath(local.getStoragePath());
            return localFileStorage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.obs.services.ObsClient"})
    public List<HuaweiObsFileStorage> huaweiObsFileStorageList() {
        return this.properties.getHuaweiObs().stream().map(obs -> {
            if (!obs.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)obs.getPlatform());
            HuaweiObsFileStorage storage = new HuaweiObsFileStorage();
            storage.setPlatform(obs.getPlatform());
            storage.setAccessKey(obs.getAccessKey());
            storage.setSecretKey(obs.getSecretKey());
            storage.setEndPoint(obs.getEndPoint());
            storage.setBucketName(obs.getBucketName());
            storage.setDomain(obs.getDomain());
            storage.setBasePath(obs.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.aliyun.oss.OSS"})
    public List<AliyunOssFileStorage> aliyunOssFileStorageList() {
        return this.properties.getAliyunOss().stream().map(oss -> {
            if (!oss.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)oss.getPlatform());
            AliyunOssFileStorage storage = new AliyunOssFileStorage();
            storage.setPlatform(oss.getPlatform());
            storage.setAccessKey(oss.getAccessKey());
            storage.setSecretKey(oss.getSecretKey());
            storage.setEndPoint(oss.getEndPoint());
            storage.setBucketName(oss.getBucketName());
            storage.setDomain(oss.getDomain());
            storage.setBasePath(oss.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.qiniu.storage.UploadManager"})
    public List<QiniuKodoFileStorage> qiniuKodoFileStorageList() {
        return this.properties.getQiniuKodo().stream().map(kodo -> {
            if (!kodo.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)kodo.getPlatform());
            QiniuKodoFileStorage storage = new QiniuKodoFileStorage();
            storage.setPlatform(kodo.getPlatform());
            storage.setAccessKey(kodo.getAccessKey());
            storage.setSecretKey(kodo.getSecretKey());
            storage.setBucketName(kodo.getBucketName());
            storage.setDomain(kodo.getDomain());
            storage.setBasePath(kodo.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.qcloud.cos.COSClient"})
    public List<TencentCosFileStorage> tencentCosFileStorageList() {
        return this.properties.getTencentCos().stream().map(cos -> {
            if (!cos.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)cos.getPlatform());
            TencentCosFileStorage storage = new TencentCosFileStorage();
            storage.setPlatform(cos.getPlatform());
            storage.setSecretId(cos.getSecretId());
            storage.setSecretKey(cos.getSecretKey());
            storage.setRegion(cos.getRegion());
            storage.setBucketName(cos.getBucketName());
            storage.setDomain(cos.getDomain());
            storage.setBasePath(cos.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.baidubce.services.bos.BosClient"})
    public List<BaiduBosFileStorage> baiduBosFileStorageList() {
        return this.properties.getBaiduBos().stream().map(bos -> {
            if (!bos.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)bos.getPlatform());
            BaiduBosFileStorage storage = new BaiduBosFileStorage();
            storage.setPlatform(bos.getPlatform());
            storage.setAccessKey(bos.getAccessKey());
            storage.setSecretKey(bos.getSecretKey());
            storage.setEndPoint(bos.getEndPoint());
            storage.setBucketName(bos.getBucketName());
            storage.setDomain(bos.getDomain());
            storage.setBasePath(bos.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.upyun.RestManager"})
    public List<UpyunUssFileStorage> upyunUssFileStorageList() {
        return this.properties.getUpyunUSS().stream().map(uss -> {
            if (!uss.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)uss.getPlatform());
            UpyunUssFileStorage storage = new UpyunUssFileStorage();
            storage.setPlatform(uss.getPlatform());
            storage.setUsername(uss.getUsername());
            storage.setPassword(uss.getPassword());
            storage.setBucketName(uss.getBucketName());
            storage.setDomain(uss.getDomain());
            storage.setBasePath(uss.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"io.minio.MinioClient"})
    public List<MinIOFileStorage> minioFileStorageList() {
        return this.properties.getMinio().stream().map(minio -> {
            if (!minio.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)minio.getPlatform());
            MinIOFileStorage storage = new MinIOFileStorage();
            storage.setPlatform(minio.getPlatform());
            storage.setAccessKey(minio.getAccessKey());
            storage.setSecretKey(minio.getSecretKey());
            storage.setEndPoint(minio.getEndPoint());
            storage.setBucketName(minio.getBucketName());
            storage.setDomain(minio.getDomain());
            storage.setBasePath(minio.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.amazonaws.services.s3.AmazonS3"})
    public List<AwsS3FileStorage> amazonS3FileStorageList() {
        return this.properties.getAwsS3().stream().map(s3 -> {
            if (!s3.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)s3.getPlatform());
            AwsS3FileStorage storage = new AwsS3FileStorage();
            storage.setPlatform(s3.getPlatform());
            storage.setAccessKey(s3.getAccessKey());
            storage.setSecretKey(s3.getSecretKey());
            storage.setRegion(s3.getRegion());
            storage.setEndPoint(s3.getEndPoint());
            storage.setBucketName(s3.getBucketName());
            storage.setDomain(s3.getDomain());
            storage.setBasePath(s3.getBasePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"org.apache.commons.net.ftp.FTPClient", "cn.hutool.extra.ftp.Ftp"})
    public List<FtpFileStorage> ftpFileStorageList() {
        return this.properties.getFtp().stream().map(ftp -> {
            if (!ftp.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)ftp.getPlatform());
            FtpFileStorage storage = new FtpFileStorage();
            storage.setPlatform(ftp.getPlatform());
            storage.setHost(ftp.getHost());
            storage.setPort(ftp.getPort());
            storage.setUser(ftp.getUser());
            storage.setPassword(ftp.getPassword());
            storage.setCharset(ftp.getCharset());
            storage.setConnectionTimeout(ftp.getConnectionTimeout());
            storage.setSoTimeout(ftp.getSoTimeout());
            storage.setServerLanguageCode(ftp.getServerLanguageCode());
            storage.setSystemKey(ftp.getSystemKey());
            storage.setIsActive(ftp.getIsActive());
            storage.setDomain(ftp.getDomain());
            storage.setBasePath(ftp.getBasePath());
            storage.setStoragePath(ftp.getStoragePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.jcraft.jsch.ChannelSftp", "cn.hutool.extra.ftp.Ftp"})
    public List<SftpFileStorage> sftpFileStorageList() {
        return this.properties.getSftp().stream().map(sftp -> {
            if (!sftp.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)sftp.getPlatform());
            SftpFileStorage storage = new SftpFileStorage();
            storage.setPlatform(sftp.getPlatform());
            storage.setHost(sftp.getHost());
            storage.setPort(sftp.getPort());
            storage.setUser(sftp.getUser());
            storage.setPassword(sftp.getPassword());
            storage.setPrivateKeyPath(sftp.getPrivateKeyPath());
            storage.setCharset(sftp.getCharset());
            storage.setConnectionTimeout(sftp.getConnectionTimeout());
            storage.setDomain(sftp.getDomain());
            storage.setBasePath(sftp.getBasePath());
            storage.setStoragePath(sftp.getStoragePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnClass(name={"com.github.sardine.Sardine"})
    public List<WebDavFileStorage> webDavFileStorageList() {
        return this.properties.getWebDav().stream().map(sftp -> {
            if (!sftp.getEnableStorage().booleanValue()) {
                return null;
            }
            log.info("\u52a0\u8f7d\u5b58\u50a8\u5e73\u53f0\uff1a{}", (Object)sftp.getPlatform());
            WebDavFileStorage storage = new WebDavFileStorage();
            storage.setPlatform(sftp.getPlatform());
            storage.setServer(sftp.getServer());
            storage.setUser(sftp.getUser());
            storage.setPassword(sftp.getPassword());
            storage.setDomain(sftp.getDomain());
            storage.setBasePath(sftp.getBasePath());
            storage.setStoragePath(sftp.getStoragePath());
            return storage;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Bean
    @ConditionalOnMissingBean(value={FileRecorder.class})
    public FileRecorder fileRecorder() {
        log.warn("\u6ca1\u6709\u627e\u5230 FileRecorder \u7684\u5b9e\u73b0\u7c7b\uff0c\u6587\u4ef6\u4e0a\u4f20\u4e4b\u5916\u7684\u90e8\u5206\u529f\u80fd\u65e0\u6cd5\u6b63\u5e38\u4f7f\u7528\uff0c\u5fc5\u987b\u5b9e\u73b0\u8be5\u63a5\u53e3\u624d\u80fd\u4f7f\u7528\u5b8c\u6574\u529f\u80fd\uff01");
        return new DefaultFileRecorder();
    }

    @Bean
    public FileStorageService fileStorageService(FileRecorder fileRecorder, List<List<? extends FileStorage>> fileStorageLists, List<FileStorageAspect> aspectList) {
        this.initDetect();
        FileStorageService service = new FileStorageService();
        service.setFileStorageList(new CopyOnWriteArrayList<FileStorage>());
        fileStorageLists.forEach(service.getFileStorageList()::addAll);
        service.setFileRecorder(fileRecorder);
        service.setProperties(this.properties);
        service.setAspectList(new CopyOnWriteArrayList<FileStorageAspect>(aspectList));
        return service;
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshedEvent() {
        FileStorageService service = (FileStorageService)this.applicationContext.getBean(FileStorageService.class);
        service.setSelf(service);
    }

    public void initDetect() {
        String template = "\u68c0\u6d4b\u5230{}\u914d\u7f6e\uff0c\u4f46\u662f\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684\u4f9d\u8d56\u5e93\uff0c\u6240\u4ee5\u65e0\u6cd5\u52a0\u8f7d\u6b64\u5b58\u50a8\u5e73\u53f0\uff01\u914d\u7f6e\u53c2\u8003\u5730\u5740\uff1ahttps://spring-file-storage.xuyanwu.cn/#/%E5%BF%AB%E9%80%9F%E5%85%A5%E9%97%A8";
        if (CollUtil.isNotEmpty(this.properties.getHuaweiObs()) && FileStorageAutoConfiguration.doesNotExistClass("com.obs.services.ObsClient")) {
            log.warn(template, (Object)"\u534e\u4e3a\u4e91 OBS ");
        }
        if (CollUtil.isNotEmpty(this.properties.getAliyunOss()) && FileStorageAutoConfiguration.doesNotExistClass("com.aliyun.oss.OSS")) {
            log.warn(template, (Object)"\u963f\u91cc\u4e91 OSS ");
        }
        if (CollUtil.isNotEmpty(this.properties.getQiniuKodo()) && FileStorageAutoConfiguration.doesNotExistClass("com.qiniu.storage.UploadManager")) {
            log.warn(template, (Object)"\u4e03\u725b\u4e91 Kodo ");
        }
        if (CollUtil.isNotEmpty(this.properties.getTencentCos()) && FileStorageAutoConfiguration.doesNotExistClass("com.qcloud.cos.COSClient")) {
            log.warn(template, (Object)"\u817e\u8baf\u4e91 COS ");
        }
        if (CollUtil.isNotEmpty(this.properties.getBaiduBos()) && FileStorageAutoConfiguration.doesNotExistClass("com.baidubce.services.bos.BosClient")) {
            log.warn(template, (Object)"\u767e\u5ea6\u4e91 BOS ");
        }
        if (CollUtil.isNotEmpty(this.properties.getUpyunUSS()) && FileStorageAutoConfiguration.doesNotExistClass("com.upyun.RestManager")) {
            log.warn(template, (Object)"\u53c8\u62cd\u4e91 USS ");
        }
        if (CollUtil.isNotEmpty(this.properties.getMinio()) && FileStorageAutoConfiguration.doesNotExistClass("io.minio.MinioClient")) {
            log.warn(template, (Object)" MinIO ");
        }
        if (CollUtil.isNotEmpty(this.properties.getAwsS3()) && FileStorageAutoConfiguration.doesNotExistClass("com.amazonaws.services.s3.AmazonS3")) {
            log.warn(template, (Object)" AmazonS3 ");
        }
        if (CollUtil.isNotEmpty(this.properties.getFtp()) && (FileStorageAutoConfiguration.doesNotExistClass("org.apache.commons.net.ftp.FTPClient") || FileStorageAutoConfiguration.doesNotExistClass("cn.hutool.extra.ftp.Ftp"))) {
            log.warn(template, (Object)" FTP ");
        }
        if (CollUtil.isNotEmpty(this.properties.getFtp()) && (FileStorageAutoConfiguration.doesNotExistClass("com.jcraft.jsch.ChannelSftp") || FileStorageAutoConfiguration.doesNotExistClass("cn.hutool.extra.ftp.Ftp"))) {
            log.warn(template, (Object)" SFTP ");
        }
        if (CollUtil.isNotEmpty(this.properties.getAwsS3()) && FileStorageAutoConfiguration.doesNotExistClass("com.github.sardine.Sardine")) {
            log.warn(template, (Object)" WebDAV ");
        }
    }

    public static boolean doesNotExistClass(String name) {
        try {
            Class.forName(name);
            return false;
        }
        catch (ClassNotFoundException e) {
            return true;
        }
    }
}

