/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.spring.webflux.callback;

import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.BlockRequestHandler;
import com.alibaba.csp.sentinel.adapter.spring.webflux.callback.DefaultBlockRequestHandler;
import com.alibaba.csp.sentinel.util.AssertUtil;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.springframework.web.server.ServerWebExchange;

public final class WebFluxCallbackManager {
    private static final BiFunction<ServerWebExchange, String, String> DEFAULT_URL_CLEANER = (w, url) -> url;
    private static final Function<ServerWebExchange, String> DEFAULT_ORIGIN_PARSER = w -> "";
    private static volatile BlockRequestHandler blockHandler = new DefaultBlockRequestHandler();
    private static volatile BiFunction<ServerWebExchange, String, String> urlCleaner = DEFAULT_URL_CLEANER;
    private static volatile Function<ServerWebExchange, String> requestOriginParser = DEFAULT_ORIGIN_PARSER;

    public static BlockRequestHandler getBlockHandler() {
        return blockHandler;
    }

    public static void resetBlockHandler() {
        blockHandler = new DefaultBlockRequestHandler();
    }

    public static void setBlockHandler(BlockRequestHandler blockHandler) {
        AssertUtil.notNull((Object)blockHandler, (String)"blockHandler cannot be null");
        WebFluxCallbackManager.blockHandler = blockHandler;
    }

    public static BiFunction<ServerWebExchange, String, String> getUrlCleaner() {
        return urlCleaner;
    }

    public static void resetUrlCleaner() {
        urlCleaner = DEFAULT_URL_CLEANER;
    }

    public static void setUrlCleaner(BiFunction<ServerWebExchange, String, String> urlCleaner) {
        AssertUtil.notNull(urlCleaner, (String)"urlCleaner cannot be null");
        WebFluxCallbackManager.urlCleaner = urlCleaner;
    }

    public static Function<ServerWebExchange, String> getRequestOriginParser() {
        return requestOriginParser;
    }

    public static void resetRequestOriginParser() {
        requestOriginParser = DEFAULT_ORIGIN_PARSER;
    }

    public static void setRequestOriginParser(Function<ServerWebExchange, String> requestOriginParser) {
        AssertUtil.notNull(requestOriginParser, (String)"requestOriginParser cannot be null");
        WebFluxCallbackManager.requestOriginParser = requestOriginParser;
    }

    private WebFluxCallbackManager() {
    }
}

