/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.ast.expr;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLDbTypedObject;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprComparor;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLReplaceable;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLExprUtils;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLLiteralExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.visitor.ParameterizedVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.VisitorFeature;
import com.alibaba.druid.util.FnvHash;
import com.alibaba.druid.util.Utils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SQLBinaryOpExpr
extends SQLExprImpl
implements SQLReplaceable,
Serializable,
SQLDbTypedObject,
Comparable<SQLBinaryOpExpr> {
    private static final long serialVersionUID = 1L;
    protected SQLExpr left;
    protected SQLExpr right;
    protected SQLBinaryOperator operator;
    protected DbType dbType;
    protected transient List<SQLObject> mergedList;

    public SQLBinaryOpExpr() {
    }

    public SQLBinaryOpExpr(DbType dbType) {
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right) {
        if (left != null) {
            left.setParent(this);
        }
        if (right != null) {
            right.setParent(this);
        }
        this.left = left;
        this.right = right;
        this.operator = operator;
        if (this.dbType == null && left instanceof SQLBinaryOpExpr) {
            this.dbType = ((SQLBinaryOpExpr)left).dbType;
        }
        if (this.dbType == null && right instanceof SQLBinaryOpExpr) {
            this.dbType = ((SQLBinaryOpExpr)right).dbType;
        }
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLBinaryOperator operator, SQLExpr right, DbType dbType) {
        if (left != null) {
            left.setParent(this);
        }
        if (right != null) {
            right.setParent(this);
        }
        this.left = left;
        this.right = right;
        this.operator = operator;
        if (dbType == null && left instanceof SQLBinaryOpExpr) {
            dbType = ((SQLBinaryOpExpr)left).dbType;
        }
        if (dbType == null && right instanceof SQLBinaryOpExpr) {
            dbType = ((SQLBinaryOpExpr)right).dbType;
        }
        this.dbType = dbType;
    }

    public SQLBinaryOpExpr(SQLExpr left, SQLExpr right, SQLBinaryOperator operator) {
        if (left != null) {
            left.setParent(this);
        }
        if (right != null) {
            right.setParent(this);
        }
        this.left = left;
        this.right = right;
        this.operator = operator;
    }

    @Override
    public DbType getDbType() {
        return this.dbType;
    }

    public void setDbType(DbType dbType) {
        this.dbType = dbType;
    }

    public SQLExpr getLeft() {
        return this.left;
    }

    public void setLeft(SQLExpr left) {
        if (left != null) {
            left.setParent(this);
        }
        this.left = left;
    }

    public SQLExpr getRight() {
        return this.right;
    }

    public void setRight(SQLExpr right) {
        if (right != null) {
            right.setParent(this);
        }
        this.right = right;
    }

    public SQLBinaryOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SQLBinaryOperator operator) {
        this.operator = operator;
    }

    @Override
    protected void accept0(SQLASTVisitor visitor) {
        if (visitor.visit(this)) {
            if (this.left != null) {
                this.left.accept(visitor);
            }
            if (this.right != null) {
                this.right.accept(visitor);
            }
        }
        visitor.endVisit(this);
    }

    public List getChildren() {
        return Arrays.asList(this.left, this.right);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.left == null ? 0 : this.left.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.right == null ? 0 : this.right.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLBinaryOpExpr)) {
            return false;
        }
        return this.equals((SQLBinaryOpExpr)obj);
    }

    public boolean equals(SQLBinaryOpExpr other) {
        return this.operator == other.operator && SQLExprUtils.equals(this.left, other.left) && SQLExprUtils.equals(this.right, other.right);
    }

    public boolean equalsIgoreOrder(SQLBinaryOpExpr other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.operator != other.operator) {
            return false;
        }
        return Utils.equals(this.left, other.left) && Utils.equals(this.right, other.right) || Utils.equals(this.left, other.right) && Utils.equals(this.right, other.left);
    }

    protected void cloneTo(SQLBinaryOpExpr x) {
        super.cloneTo(x);
        if (this.left != null) {
            x.setLeft(this.left.clone());
        }
        if (this.right != null) {
            x.setRight(this.right.clone());
        }
        x.operator = this.operator;
        x.dbType = this.dbType;
        x.parenthesized = this.parenthesized;
        if (this.hint != null) {
            x.hint = this.hint.clone();
        }
        x.setParenthesized(this.parenthesized);
    }

    @Override
    public SQLBinaryOpExpr clone() {
        SQLBinaryOpExpr x = new SQLBinaryOpExpr();
        this.cloneTo(x);
        return x;
    }

    @Override
    public String toString() {
        return SQLUtils.toSQLString((SQLObject)this, this.getDbType());
    }

    public static SQLExpr combine(List<? extends SQLExpr> items, SQLBinaryOperator op) {
        if (items == null || op == null) {
            return null;
        }
        int size = items.size();
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return items.get(0);
        }
        SQLBinaryOpExpr expr = new SQLBinaryOpExpr(items.get(0), op, items.get(1));
        for (int i = 2; i < size; ++i) {
            SQLExpr item = items.get(i);
            expr = new SQLBinaryOpExpr((SQLExpr)expr, op, item);
        }
        return expr;
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x) {
        return SQLBinaryOpExpr.split(x, x.getOperator());
    }

    public static List<SQLExpr> split(SQLExpr x, SQLBinaryOperator op) {
        if (x instanceof SQLBinaryOpExprGroup) {
            SQLBinaryOpExprGroup group = (SQLBinaryOpExprGroup)x;
            if (group.getOperator() == op) {
                return new ArrayList<SQLExpr>(group.getItems());
            }
        } else if (x instanceof SQLBinaryOpExpr) {
            return SQLBinaryOpExpr.split((SQLBinaryOpExpr)x, op);
        }
        ArrayList<SQLExpr> list = new ArrayList<SQLExpr>(1);
        list.add(x);
        return list;
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x, SQLBinaryOperator op) {
        if (x.getOperator() != op) {
            ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>(1);
            groupList.add(x);
            return groupList;
        }
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        SQLBinaryOpExpr.split(groupList, x, op);
        return groupList;
    }

    public static void split(List<SQLExpr> outList, SQLExpr expr, SQLBinaryOperator op) {
        ArrayList<SQLExpr> rightList;
        block14: {
            if (expr == null) {
                return;
            }
            if (!(expr instanceof SQLBinaryOpExpr)) {
                outList.add(expr);
                return;
            }
            SQLBinaryOpExpr binaryExpr = (SQLBinaryOpExpr)expr;
            if (binaryExpr.getOperator() != op) {
                outList.add(binaryExpr);
                return;
            }
            rightList = new ArrayList<SQLExpr>();
            rightList.add(binaryExpr.getRight());
            SQLExpr left = binaryExpr.getLeft();
            while (left instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr leftBinary = (SQLBinaryOpExpr)left;
                if (leftBinary.operator == op) {
                    left = leftBinary.getLeft();
                    rightList.add(leftBinary.getRight());
                    continue;
                }
                outList.add(leftBinary);
                break block14;
            }
            outList.add(left);
        }
        for (int i = rightList.size() - 1; i >= 0; --i) {
            SQLExpr right = (SQLExpr)rightList.get(i);
            if (right instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr binaryRight = (SQLBinaryOpExpr)right;
                if (binaryRight.operator == op) {
                    SQLExpr rightLeft = binaryRight.getLeft();
                    if (rightLeft instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr rightLeftBinary = (SQLBinaryOpExpr)rightLeft;
                        if (rightLeftBinary.operator == op) {
                            SQLBinaryOpExpr.split(outList, rightLeftBinary, op);
                        } else {
                            outList.add(rightLeftBinary);
                        }
                    } else {
                        outList.add(rightLeft);
                    }
                    SQLExpr rightRight = binaryRight.getRight();
                    if (rightRight instanceof SQLBinaryOpExpr) {
                        SQLBinaryOpExpr rightRightBinary = (SQLBinaryOpExpr)rightRight;
                        if (rightRightBinary.operator == op) {
                            SQLBinaryOpExpr.split(outList, rightRightBinary, op);
                            continue;
                        }
                        outList.add(rightRightBinary);
                        continue;
                    }
                    outList.add(rightRight);
                    continue;
                }
                outList.add(binaryRight);
                continue;
            }
            outList.add(right);
        }
    }

    public static SQLExpr and(SQLExpr a, SQLExpr b) {
        SQLBinaryOpExprGroup group;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof SQLBinaryOpExprGroup) {
            group = (SQLBinaryOpExprGroup)a;
            if (group.getOperator() == SQLBinaryOperator.BooleanAnd) {
                group.add(b);
                return group;
            }
            if (group.getOperator() == SQLBinaryOperator.BooleanOr && group.getItems().size() == 1) {
                a = group.getItems().get(0).clone();
            }
        }
        if (b instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr bb = (SQLBinaryOpExpr)b;
            if (bb.operator == SQLBinaryOperator.BooleanAnd) {
                return SQLBinaryOpExpr.and(SQLBinaryOpExpr.and(a, bb.left), bb.right);
            }
        } else if (b instanceof SQLBinaryOpExprGroup && (group = (SQLBinaryOpExprGroup)b).getOperator() == SQLBinaryOperator.BooleanOr && group.getItems().size() == 1) {
            b = group.getItems().get(0).clone();
        }
        if (a instanceof SQLBinaryOpExpr && b instanceof SQLBinaryOpExprGroup && ((SQLBinaryOpExprGroup)b).getOperator() == SQLBinaryOperator.BooleanAnd) {
            group = (SQLBinaryOpExprGroup)b;
            group.add(0, a);
            return group;
        }
        return new SQLBinaryOpExpr(a, SQLBinaryOperator.BooleanAnd, b);
    }

    public static SQLExpr and(SQLExpr a, SQLExpr b, SQLExpr c) {
        return SQLBinaryOpExpr.and(SQLBinaryOpExpr.and(a, b), c);
    }

    public static SQLExpr or(SQLExpr a, SQLExpr b) {
        SQLBinaryOpExprGroup group;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof SQLBinaryOpExprGroup && (group = (SQLBinaryOpExprGroup)a).getOperator() == SQLBinaryOperator.BooleanOr) {
            group.add(b);
            return group;
        }
        if (b instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr bb = (SQLBinaryOpExpr)b;
            if (bb.operator == SQLBinaryOperator.BooleanOr) {
                return SQLBinaryOpExpr.or(SQLBinaryOpExpr.or(a, bb.left), bb.right);
            }
        }
        return new SQLBinaryOpExpr(a, SQLBinaryOperator.BooleanOr, b);
    }

    public static SQLExpr or(List<? extends SQLExpr> list) {
        if (list.isEmpty()) {
            return null;
        }
        SQLExpr first = list.get(0);
        for (int i = 1; i < list.size(); ++i) {
            first = SQLBinaryOpExpr.or(first, list.get(i));
        }
        return first;
    }

    public static SQLExpr andIfNotExists(SQLExpr a, SQLExpr b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<SQLExpr> groupListA = new ArrayList<SQLExpr>();
        ArrayList<SQLExpr> groupListB = new ArrayList<SQLExpr>();
        SQLBinaryOpExpr.split(groupListA, a, SQLBinaryOperator.BooleanAnd);
        SQLBinaryOpExpr.split(groupListB, b, SQLBinaryOperator.BooleanAnd);
        for (SQLExpr itemB : groupListB) {
            boolean exist = false;
            for (SQLExpr itemA : groupListA) {
                if (itemA.equals(itemB)) {
                    exist = true;
                    continue;
                }
                if (!(itemA instanceof SQLBinaryOpExpr) || !(itemB instanceof SQLBinaryOpExpr) || !((SQLBinaryOpExpr)itemA).equalsIgoreOrder((SQLBinaryOpExpr)itemB)) continue;
                exist = true;
            }
            if (exist) continue;
            groupListA.add(itemB);
        }
        return SQLBinaryOpExpr.combine(groupListA, SQLBinaryOperator.BooleanAnd);
    }

    public static SQLBinaryOpExpr isNotNull(SQLExpr expr) {
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.IsNot, new SQLNullExpr());
    }

    public static SQLBinaryOpExpr isNull(SQLExpr expr) {
        return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Is, new SQLNullExpr());
    }

    @Override
    public boolean replace(SQLExpr expr, SQLExpr target) {
        SQLBinaryOperator operator;
        SQLObject parent = this.getParent();
        if (this.left == expr) {
            if (target == null) {
                if (parent instanceof SQLReplaceable) {
                    return ((SQLReplaceable)((Object)parent)).replace(this, this.right);
                }
                return false;
            }
            this.setLeft(target);
            return true;
        }
        if (this.right == expr) {
            if (target == null) {
                if (parent instanceof SQLReplaceable) {
                    return ((SQLReplaceable)((Object)parent)).replace(this, this.left);
                }
                return false;
            }
            this.setRight(target);
            return true;
        }
        return this.left instanceof SQLBinaryOpExpr && (operator = ((SQLBinaryOpExpr)this.left).getOperator()) == SQLBinaryOperator.BooleanAnd && ((SQLBinaryOpExpr)this.left).replace(expr, target);
    }

    public SQLExpr other(SQLExpr x) {
        if (x == this.left) {
            return this.right;
        }
        if (x == this.right) {
            return this.left;
        }
        return null;
    }

    public boolean contains(SQLExpr item) {
        if (item instanceof SQLBinaryOpExpr) {
            if (this.equalsIgoreOrder((SQLBinaryOpExpr)item)) {
                return true;
            }
            return this.left.equals(item) || this.right.equals(item);
        }
        return false;
    }

    @Override
    public SQLDataType computeDataType() {
        if (this.operator == null) {
            return null;
        }
        if (this.operator.isRelational()) {
            return SQLBooleanExpr.DATA_TYPE;
        }
        SQLDataType leftDataType = null;
        SQLDataType rightDataType = null;
        if (this.left != null) {
            leftDataType = this.left.computeDataType();
        }
        if (this.right != null) {
            rightDataType = this.right.computeDataType();
        }
        switch (this.operator) {
            case Concat: {
                if (leftDataType != null) {
                    return leftDataType;
                }
                if (rightDataType != null) {
                    return rightDataType;
                }
                return SQLCharExpr.DATA_TYPE;
            }
            case BooleanXor: 
            case Modulus: 
            case Mod: 
            case DIV: 
            case Divide: {
                if (leftDataType != null) {
                    return leftDataType;
                }
                if (rightDataType != null) {
                    return rightDataType;
                }
                return null;
            }
            case Subtract: 
            case Add: 
            case Multiply: {
                if (leftDataType != null) {
                    if (rightDataType != null) {
                        if (leftDataType.nameHashCode64() == FnvHash.Constants.BIGINT && rightDataType.nameHashCode64() == FnvHash.Constants.NUMBER) {
                            return rightDataType;
                        }
                        if (leftDataType.isInt() && rightDataType.nameHashCode64() == FnvHash.Constants.INTERVAL) {
                            return rightDataType;
                        }
                        if (!(leftDataType.nameHashCode64() != FnvHash.Constants.DATE && leftDataType.nameHashCode64() != FnvHash.Constants.DATETIME && leftDataType.nameHashCode64() != FnvHash.Constants.TIMESTAMP || rightDataType.nameHashCode64() != FnvHash.Constants.DATE && rightDataType.nameHashCode64() != FnvHash.Constants.DATETIME && rightDataType.nameHashCode64() != FnvHash.Constants.TIMESTAMP)) {
                            return new SQLDataTypeImpl("BIGING");
                        }
                    }
                    return leftDataType;
                }
                return null;
            }
        }
        return null;
    }

    public boolean conditionContainsTable(String alias) {
        if (this.left == null || this.right == null) {
            return false;
        }
        if (this.left instanceof SQLPropertyExpr ? ((SQLPropertyExpr)this.left).matchOwner(alias) : this.left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)this.left).conditionContainsTable(alias)) {
            return true;
        }
        if (this.right instanceof SQLPropertyExpr) {
            if (((SQLPropertyExpr)this.right).matchOwner(alias)) {
                return true;
            }
        } else if (this.right instanceof SQLBinaryOpExpr) {
            return ((SQLBinaryOpExpr)this.right).conditionContainsTable(alias);
        }
        return false;
    }

    public boolean conditionContainsColumn(String column) {
        if (this.left == null || this.right == null) {
            return false;
        }
        return this.left instanceof SQLIdentifierExpr ? ((SQLIdentifierExpr)this.left).nameEquals(column) : this.right instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)this.right).nameEquals(column);
    }

    public static SQLBinaryOpExpr merge(ParameterizedVisitor v, SQLBinaryOpExpr x) {
        SQLBinaryOpExpr mergedLeft;
        SQLObject parent = x.parent;
        while (x.right instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr mergedRight;
            SQLBinaryOpExpr rightBinary = (SQLBinaryOpExpr)x.right;
            if (x.left instanceof SQLBinaryOpExpr) {
                SQLBinaryOpExpr leftBinaryExpr = (SQLBinaryOpExpr)x.left;
                if (SQLExprUtils.equals(leftBinaryExpr.right, rightBinary)) {
                    x = leftBinaryExpr;
                    v.incrementReplaceCunt();
                    continue;
                }
            }
            if ((mergedRight = SQLBinaryOpExpr.merge(v, rightBinary)) != x.right) {
                x = new SQLBinaryOpExpr(x.left, x.operator, mergedRight);
                v.incrementReplaceCunt();
            }
            x.setParent(parent);
            break;
        }
        if (x.left instanceof SQLBinaryOpExpr && (mergedLeft = SQLBinaryOpExpr.merge(v, (SQLBinaryOpExpr)x.left)) != x.left) {
            SQLBinaryOpExpr tmp = new SQLBinaryOpExpr((SQLExpr)mergedLeft, x.operator, x.right);
            tmp.setParent(parent);
            x = tmp;
            v.incrementReplaceCunt();
        }
        if (x.operator == SQLBinaryOperator.BooleanOr && !v.isEnabled(VisitorFeature.OutputParameterizedQuesUnMergeInList) && x.left instanceof SQLBinaryOpExpr && x.right instanceof SQLBinaryOpExpr) {
            SQLBinaryOpExpr leftBinary = (SQLBinaryOpExpr)x.left;
            SQLBinaryOpExpr rightBinary = (SQLBinaryOpExpr)x.right;
            if (SQLBinaryOpExpr.mergeEqual(leftBinary, rightBinary)) {
                v.incrementReplaceCunt();
                leftBinary.setParent(x.parent);
                leftBinary.addMergedItem(rightBinary);
                return leftBinary;
            }
            if (SQLExprUtils.isLiteralExpr(leftBinary.left) && leftBinary.operator == SQLBinaryOperator.BooleanOr && SQLBinaryOpExpr.mergeEqual(leftBinary.right, x.right)) {
                v.incrementReplaceCunt();
                leftBinary.addMergedItem(rightBinary);
                return leftBinary;
            }
        }
        return x;
    }

    private void addMergedItem(SQLBinaryOpExpr item) {
        if (this.mergedList == null) {
            this.mergedList = new ArrayList<SQLObject>();
        }
        this.mergedList.add(item);
    }

    public List<SQLObject> getMergedList() {
        return this.mergedList;
    }

    private static boolean mergeEqual(SQLExpr a, SQLExpr b) {
        if (!(a instanceof SQLBinaryOpExpr)) {
            return false;
        }
        if (!(b instanceof SQLBinaryOpExpr)) {
            return false;
        }
        SQLBinaryOpExpr binaryA = (SQLBinaryOpExpr)a;
        SQLBinaryOpExpr binaryB = (SQLBinaryOpExpr)b;
        if (binaryA.operator != SQLBinaryOperator.Equality) {
            return false;
        }
        if (binaryB.operator != SQLBinaryOperator.Equality) {
            return false;
        }
        if (!(binaryA.right instanceof SQLLiteralExpr) && !(binaryA.right instanceof SQLVariantRefExpr)) {
            return false;
        }
        if (!(binaryB.right instanceof SQLLiteralExpr) && !(binaryB.right instanceof SQLVariantRefExpr)) {
            return false;
        }
        return binaryA.left.equals(binaryB.left);
    }

    public static boolean isOr(SQLExpr x) {
        return x instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.BooleanOr;
    }

    public static boolean isAnd(SQLExpr x) {
        return x instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)x).getOperator() == SQLBinaryOperator.BooleanAnd;
    }

    public boolean isLeftNameAndRightLiteral() {
        return this.left instanceof SQLName && this.right instanceof SQLLiteralExpr;
    }

    public boolean isLeftFunctionAndRightLiteral() {
        return this.left instanceof SQLMethodInvokeExpr && this.right instanceof SQLLiteralExpr;
    }

    public boolean isNameAndLiteral() {
        return this.left instanceof SQLLiteralExpr && this.right instanceof SQLName || this.left instanceof SQLName && this.right instanceof SQLLiteralExpr;
    }

    public boolean isBothName() {
        return this.left instanceof SQLName && this.right instanceof SQLName;
    }

    @Override
    public int compareTo(SQLBinaryOpExpr o) {
        int leftResult = SQLExprComparor.compareTo(this.left, o.left);
        if (leftResult != 0) {
            return leftResult;
        }
        int opResult = this.operator.compareTo(o.operator);
        if (opResult != 0) {
            return opResult;
        }
        int rightResult = SQLExprComparor.compareTo(this.right, o.right);
        if (rightResult != 0) {
            return rightResult;
        }
        return 0;
    }

    public boolean isLeftLiteralAndRightName() {
        return this.right instanceof SQLName && this.left instanceof SQLLiteralExpr;
    }

    public static SQLBinaryOpExpr conditionEq(String column, String value) {
        return new SQLBinaryOpExpr(SQLUtils.toSQLExpr(column), SQLBinaryOperator.Equality, new SQLCharExpr(value));
    }

    public static SQLBinaryOpExpr conditionEq(String column, int value) {
        return new SQLBinaryOpExpr(SQLUtils.toSQLExpr(column), SQLBinaryOperator.Equality, new SQLIntegerExpr(value));
    }

    public static SQLBinaryOpExpr conditionLike(String column, String value) {
        return new SQLBinaryOpExpr(SQLUtils.toSQLExpr(column), SQLBinaryOperator.Like, new SQLCharExpr(value));
    }

    public static SQLBinaryOpExpr conditionLike(String column, SQLExpr value) {
        return new SQLBinaryOpExpr(SQLUtils.toSQLExpr(column), SQLBinaryOperator.Like, value);
    }

    public static SQLBinaryOpExpr eq(SQLExpr a, SQLExpr b) {
        return new SQLBinaryOpExpr(a, SQLBinaryOperator.Equality, b);
    }
}

