/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.stat;

import com.alibaba.druid.VERSION;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.sql.visitor.SQLEvalVisitorUtils;
import com.alibaba.druid.stat.DruidDataSourceStatManager;
import com.alibaba.druid.stat.JdbcDataSourceStat;
import com.alibaba.druid.stat.JdbcStatManager;
import com.alibaba.druid.support.http.stat.WebAppStatManager;
import com.alibaba.druid.support.spring.stat.SpringStatManager;
import com.alibaba.druid.util.DruidDataSourceUtils;
import com.alibaba.druid.util.JdbcSqlStatUtils;
import com.alibaba.druid.util.StringUtils;
import com.alibaba.druid.util.Utils;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;

public final class DruidStatManagerFacade {
    private static final DruidStatManagerFacade instance = new DruidStatManagerFacade();
    private boolean resetEnable = true;
    private final AtomicLong resetCount = new AtomicLong();

    private DruidStatManagerFacade() {
    }

    public static DruidStatManagerFacade getInstance() {
        return instance;
    }

    private Set<Object> getDruidDataSourceInstances() {
        return DruidDataSourceStatManager.getInstances().keySet();
    }

    public Object getDruidDataSourceByName(String name) {
        for (Object o : this.getDruidDataSourceInstances()) {
            String itemName = DruidDataSourceUtils.getName(o);
            if (!StringUtils.equals(name, itemName)) continue;
            return o;
        }
        return null;
    }

    public void resetDataSourceStat() {
        DruidDataSourceStatManager.getInstance().reset();
    }

    public void resetSqlStat() {
        JdbcStatManager.getInstance().reset();
    }

    public void resetAll() {
        if (!this.isResetEnable()) {
            return;
        }
        SpringStatManager.getInstance().resetStat();
        WebAppStatManager.getInstance().resetStat();
        this.resetSqlStat();
        this.resetDataSourceStat();
        this.resetCount.incrementAndGet();
    }

    public void logAndResetDataSource() {
        if (!this.isResetEnable()) {
            return;
        }
        DruidDataSourceStatManager.getInstance().logAndResetDataSource();
    }

    public boolean isResetEnable() {
        return this.resetEnable;
    }

    public void setResetEnable(boolean resetEnable) {
        this.resetEnable = resetEnable;
    }

    public Object getSqlStatById(Integer id) {
        for (Object ds : this.getDruidDataSourceInstances()) {
            Object sqlStat = DruidDataSourceUtils.getSqlStat(ds, id);
            if (sqlStat == null) continue;
            return sqlStat;
        }
        return null;
    }

    public Map<String, Object> getDataSourceStatData(Integer id) {
        if (id == null) {
            return null;
        }
        Object datasource = this.getDruidDataSourceById(id);
        return datasource == null ? null : this.dataSourceToMapData(datasource, false);
    }

    public Object getDruidDataSourceById(Integer identity) {
        if (identity == null) {
            return null;
        }
        for (Object datasource : this.getDruidDataSourceInstances()) {
            if (System.identityHashCode(datasource) != identity) continue;
            return datasource;
        }
        return null;
    }

    public List<Map<String, Object>> getSqlStatDataList(Integer dataSourceId) {
        Set<Object> dataSources = this.getDruidDataSourceInstances();
        if (dataSourceId == null) {
            JdbcDataSourceStat globalStat = JdbcDataSourceStat.getGlobal();
            ArrayList<Map<String, Object>> sqlList = new ArrayList<Map<String, Object>>();
            DruidDataSource globalStatDataSource = null;
            for (Object datasource : dataSources) {
                if (datasource instanceof DruidDataSource && ((DruidDataSource)datasource).getDataSourceStat() == globalStat) {
                    if (globalStatDataSource != null) continue;
                    globalStatDataSource = (DruidDataSource)datasource;
                }
                sqlList.addAll(this.getSqlStatDataList(datasource));
            }
            return sqlList;
        }
        for (Object datasource : dataSources) {
            if (dataSourceId != null && dataSourceId != System.identityHashCode(datasource)) continue;
            return this.getSqlStatDataList(datasource);
        }
        return new ArrayList<Map<String, Object>>();
    }

    public Map<String, Object> getWallStatMap(Integer dataSourceId) {
        Set<Object> dataSources = this.getDruidDataSourceInstances();
        if (dataSourceId == null) {
            Map<String, Object> map = new HashMap<String, Object>();
            for (Object datasource : dataSources) {
                Map<String, Object> wallStat = DruidDataSourceUtils.getWallStatMap(datasource);
                map = DruidStatManagerFacade.mergeWallStat(map, wallStat);
            }
            return map;
        }
        for (Object datasource : dataSources) {
            if (dataSourceId != null && dataSourceId != System.identityHashCode(datasource)) continue;
            return DruidDataSourceUtils.getWallStatMap(datasource);
        }
        return new HashMap<String, Object>();
    }

    public static Map mergWallStat(Map mapA, Map mapB) {
        return DruidStatManagerFacade.mergeWallStat(mapA, mapB);
    }

    public static Map mergeWallStat(Map mapA, Map mapB) {
        if (mapA == null || mapA.size() == 0) {
            return mapB;
        }
        if (mapB == null || mapB.size() == 0) {
            return mapA;
        }
        LinkedHashMap<String, Object> newMap = new LinkedHashMap<String, Object>();
        Iterator iterator = mapB.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item;
            Map.Entry entry = item = iterator.next();
            String key = (String)entry.getKey();
            Object valueB = entry.getValue();
            Object valueA = mapA.get(key);
            if (valueA == null) {
                newMap.put(key, valueB);
                continue;
            }
            if (valueB == null) {
                newMap.put(key, valueA);
                continue;
            }
            if ("blackList".equals(key)) {
                Object blackItem2;
                HashMap<String, Map> newSet = new HashMap<String, Map>();
                Collection collectionA = (Collection)valueA;
                for (Object blackItem2 : collectionA) {
                    if (newSet.size() >= 1000) break;
                    String sql = (String)blackItem2.get("sql");
                    Map oldItem = (Map)newSet.get(sql);
                    newSet.put(sql, DruidStatManagerFacade.mergeWallStat(oldItem, (Map)blackItem2));
                }
                Collection collectionB = (Collection)valueB;
                blackItem2 = collectionB.iterator();
                while (blackItem2.hasNext()) {
                    Map blackItem3 = (Map)blackItem2.next();
                    if (newSet.size() >= 1000) break;
                    String sql = (String)blackItem3.get("sql");
                    Map oldItem = (Map)newSet.get(sql);
                    newSet.put(sql, DruidStatManagerFacade.mergeWallStat(oldItem, blackItem3));
                }
                newMap.put(key, newSet.values());
                continue;
            }
            if (valueA instanceof Map && valueB instanceof Map) {
                Map newValue = DruidStatManagerFacade.mergeWallStat((Map)valueA, (Map)valueB);
                newMap.put(key, newValue);
                continue;
            }
            if (valueA instanceof Set && valueB instanceof Set) {
                HashSet set = new HashSet();
                set.addAll((Set)valueA);
                set.addAll((Set)valueB);
                newMap.put(key, set);
                continue;
            }
            if (valueA instanceof List && valueB instanceof List) {
                List<Map<String, Object>> mergedList = DruidStatManagerFacade.mergeNamedList((List)valueA, (List)valueB);
                newMap.put(key, mergedList);
                continue;
            }
            if (valueA instanceof long[] && valueB instanceof long[]) {
                long[] arrayA = (long[])valueA;
                long[] arrayB = (long[])valueB;
                int len = arrayA.length >= arrayB.length ? arrayA.length : arrayB.length;
                long[] sum = new long[len];
                for (int i = 0; i < sum.length; ++i) {
                    if (i < arrayA.length) {
                        int n = i;
                        sum[n] = sum[n] + (long)arrayA.length;
                    }
                    if (i >= arrayB.length) continue;
                    int n = i;
                    sum[n] = sum[n] + (long)arrayB.length;
                }
                newMap.put(key, sum);
                continue;
            }
            if (valueA instanceof String && valueB instanceof String) {
                newMap.put(key, valueA);
                continue;
            }
            Object sum = SQLEvalVisitorUtils.add(valueA, valueB);
            newMap.put(key, sum);
        }
        return newMap;
    }

    private static List<Map<String, Object>> mergeNamedList(List listA, List listB) {
        HashMap<String, Map> mapped = new HashMap<String, Map>();
        for (Object item : listA) {
            Map map = (Map)item;
            String name = (String)map.get("name");
            mapped.put(name, map);
        }
        ArrayList<Map<String, Object>> mergedList = new ArrayList<Map<String, Object>>();
        for (Object item : listB) {
            Map mapB = (Map)item;
            String name = (String)mapB.get("name");
            Map mapA = (Map)mapped.get(name);
            Map mergedMap = DruidStatManagerFacade.mergeWallStat(mapA, mapB);
            mergedList.add(mergedMap);
        }
        return mergedList;
    }

    public List<Map<String, Object>> getSqlStatDataList(Object datasource) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map sqlStatMap = DruidDataSourceUtils.getSqlStatMap(datasource);
        for (Object sqlStat : sqlStatMap.values()) {
            Map<String, Object> data = JdbcSqlStatUtils.getData(sqlStat);
            long executeCount = (Long)data.get("ExecuteCount");
            long runningCount = (Long)data.get("RunningCount");
            if (executeCount == 0L && runningCount == 0L) continue;
            result.add(data);
        }
        return result;
    }

    public Map<String, Object> getSqlStatData(Integer id) {
        if (id == null) {
            return null;
        }
        Object sqlStat = this.getSqlStatById(id);
        if (sqlStat == null) {
            return null;
        }
        return JdbcSqlStatUtils.getData(sqlStat);
    }

    public List<Map<String, Object>> getDataSourceStatDataList() {
        return this.getDataSourceStatDataList(false);
    }

    public List<Map<String, Object>> getDataSourceStatDataList(boolean includeSqlList) {
        ArrayList<Map<String, Object>> datasourceList = new ArrayList<Map<String, Object>>();
        for (Object dataSource : this.getDruidDataSourceInstances()) {
            datasourceList.add(this.dataSourceToMapData(dataSource, includeSqlList));
        }
        return datasourceList;
    }

    public List<List<String>> getActiveConnStackTraceList() {
        ArrayList<List<String>> traceList = new ArrayList<List<String>>();
        for (Object dataSource : this.getDruidDataSourceInstances()) {
            List<String> stacks = ((DruidDataSource)dataSource).getActiveConnectionStackTrace();
            if (stacks.size() <= 0) continue;
            traceList.add(stacks);
        }
        return traceList;
    }

    public Map<String, Object> returnJSONBasicStat() {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        dataMap.put("Version", VERSION.getVersionNumber());
        dataMap.put("Drivers", this.getDriversData());
        dataMap.put("ResetEnable", this.isResetEnable());
        dataMap.put("ResetCount", this.getResetCount());
        dataMap.put("JavaVMName", System.getProperty("java.vm.name"));
        dataMap.put("JavaVersion", System.getProperty("java.version"));
        dataMap.put("JavaClassPath", System.getProperty("java.class.path"));
        dataMap.put("StartTime", Utils.getStartTime());
        return dataMap;
    }

    public long getResetCount() {
        return this.resetCount.get();
    }

    private List<String> getDriversData() {
        ArrayList<String> drivers = new ArrayList<String>();
        Enumeration<Driver> e = DriverManager.getDrivers();
        while (e.hasMoreElements()) {
            Driver driver = e.nextElement();
            drivers.add(driver.getClass().getName());
        }
        return drivers;
    }

    public List<Map<String, Object>> getPoolingConnectionInfoByDataSourceId(Integer id) {
        Object datasource = this.getDruidDataSourceById(id);
        if (datasource == null) {
            return null;
        }
        return DruidDataSourceUtils.getPoolingConnectionInfo(datasource);
    }

    public List<String> getActiveConnectionStackTraceByDataSourceId(Integer id) {
        Object datasource = this.getDruidDataSourceById(id);
        if (datasource == null || !DruidDataSourceUtils.isRemoveAbandoned(datasource)) {
            return null;
        }
        return DruidDataSourceUtils.getActiveConnectionStackTrace(datasource);
    }

    private Map<String, Object> dataSourceToMapData(Object dataSource, boolean includeSql) {
        Map<String, Object> map = DruidDataSourceUtils.getStatData(dataSource);
        if (includeSql) {
            List<Map<String, Object>> sqlList = this.getSqlStatDataList(dataSource);
            map.put("SQL", sqlList);
        }
        return map;
    }
}

