/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.excel.support;

import com.alibaba.excel.exception.ExcelCommonException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.poifs.filesystem.FileMagic;

public enum ExcelTypeEnum {
    XLS(".xls"),
    XLSX(".xlsx");

    private String value;

    private ExcelTypeEnum(String value) {
        this.setValue(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExcelTypeEnum valueOf(File file, InputStream inputStream, ExcelTypeEnum excelType) {
        try {
            FileMagic fileMagic;
            if (file != null) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                try {
                    fileMagic = FileMagic.valueOf((InputStream)bufferedInputStream);
                }
                finally {
                    bufferedInputStream.close();
                }
                if (!FileMagic.OLE2.equals((Object)fileMagic) && !FileMagic.OOXML.equals((Object)fileMagic)) {
                    String fileName = file.getName();
                    if (fileName.endsWith(XLSX.getValue())) {
                        return XLSX;
                    }
                    if (fileName.endsWith(XLS.getValue())) {
                        return XLS;
                    }
                    throw new ExcelCommonException("Unknown excel type.");
                }
            } else {
                fileMagic = FileMagic.valueOf((InputStream)inputStream);
            }
            if (FileMagic.OLE2.equals((Object)fileMagic)) {
                return XLS;
            }
            if (FileMagic.OOXML.equals((Object)fileMagic)) {
                return XLSX;
            }
        }
        catch (IOException e) {
            if (excelType != null) {
                return excelType;
            }
            throw new ExcelCommonException("Convert excel format exception.You can try specifying the 'excelType' yourself", e);
        }
        if (excelType != null) {
            return excelType;
        }
        throw new ExcelCommonException("Convert excel format exception.You can try specifying the 'excelType' yourself");
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

