/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.instance.manager.plain;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.net.URI;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpHelper.class);
    public static final Integer REST_STATE_OK = 20000;
    public static final Integer REST_STATE_TOKEN_INVALID = 50014;
    public static final Integer REST_STATE_ERROR = 50000;
    private CloseableHttpClient httpclient;

    public HttpHelper() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.setMaxConnPerRoute(50);
        builder.setMaxConnTotal(100);
        try {
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
                    return true;
                }
            }).build();
            this.httpclient = HttpClientBuilder.create().setSSLContext(sslContext).setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build())).build();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String get(String url, Map<String, String> heads, int timeout) {
        url = url.trim();
        CloseableHttpResponse response = null;
        HttpGet httpGet = null;
        try {
            URI uri = new URIBuilder(url).build();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpGet = new HttpGet(uri);
            if (heads != null) {
                for (Map.Entry<String, String> entry : heads.entrySet()) {
                    httpGet.setHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(config);
            response = this.httpclient.execute((HttpUriRequest)httpGet, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            try {
                String errorMsg = EntityUtils.toString((HttpEntity)response.getEntity());
                throw new RuntimeException("requestGet remote error, url=" + uri.toString() + ", code=" + statusCode + ", error msg=" + errorMsg);
            }
            catch (Throwable t) {
                throw new RuntimeException("requestGet remote error, request : " + url, t);
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (httpGet != null) {
                httpGet.releaseConnection();
            }
        }
    }

    public String post(String url, Map<String, String> heads, Object requestBody, int timeout) {
        return this.post0(url, heads, JSON.toJSONString((Object)requestBody), timeout);
    }

    public String post0(String url, Map<String, String> heads, String requestBody, int timeout) {
        url = url.trim();
        HttpPost httpPost = null;
        CloseableHttpResponse response = null;
        try {
            URI uri = new URIBuilder(url).build();
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).setSocketTimeout(timeout).build();
            httpPost = new HttpPost(uri);
            StringEntity entity = new StringEntity(requestBody, "UTF-8");
            httpPost.setEntity((HttpEntity)entity);
            httpPost.setHeader("Content-Type", "application/json;charset=utf8");
            if (heads != null) {
                for (Map.Entry<String, String> entry : heads.entrySet()) {
                    httpPost.setHeader(entry.getKey(), entry.getValue());
                }
            }
            HttpClientContext context = HttpClientContext.create();
            context.setRequestConfig(config);
            response = this.httpclient.execute((HttpUriRequest)httpPost, (HttpContext)context);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity());
                return string;
            }
            try {
                throw new RuntimeException("requestPost remote error, request : " + url + ", statusCode=" + statusCode + ";" + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            catch (Throwable t) {
                throw new RuntimeException("requestPost remote error, request : " + url, t);
            }
        }
        finally {
            if (response != null) {
                try {
                    response.close();
                }
                catch (IOException iOException) {}
            }
            if (httpPost != null) {
                httpPost.releaseConnection();
            }
        }
    }

    public void close() {
        if (this.httpclient != null) {
            try {
                this.httpclient.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

