/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.tddl.dbsync.binlog.event;

import com.taobao.tddl.dbsync.binlog.JsonConversion;
import com.taobao.tddl.dbsync.binlog.JsonDiffConversion;
import com.taobao.tddl.dbsync.binlog.LogBuffer;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RowsLogBuffer {
    protected static final Log logger = LogFactory.getLog(RowsLogBuffer.class);
    public static final long DATETIMEF_INT_OFS = 0x8000000000L;
    public static final long TIMEF_INT_OFS = 0x800000L;
    public static final long TIMEF_OFS = 0x800000000000L;
    private static char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private final LogBuffer buffer;
    private final int columnLen;
    private final int jsonColumnCount;
    private final String charsetName;
    private final BitSet nullBits;
    private int nullBitIndex;
    private final boolean partial;
    private final BitSet partialBits;
    private boolean fNull;
    private int javaType;
    private int length;
    private Serializable value;

    public RowsLogBuffer(LogBuffer buffer, int columnLen, String charsetName, int jsonColumnCount, boolean partial) {
        this.buffer = buffer;
        this.columnLen = columnLen;
        this.charsetName = charsetName;
        this.partial = partial;
        this.jsonColumnCount = jsonColumnCount;
        this.nullBits = new BitSet(columnLen);
        this.partialBits = new BitSet(1);
    }

    public final boolean nextOneRow(BitSet columns) {
        return this.nextOneRow(columns, false);
    }

    public final boolean nextOneRow(BitSet columns, boolean after) {
        boolean hasOneRow = this.buffer.hasRemaining();
        if (hasOneRow) {
            int column = 0;
            for (int i = 0; i < this.columnLen; ++i) {
                if (!columns.get(i)) continue;
                ++column;
            }
            if (after && this.partial) {
                this.partialBits.clear();
                long valueOptions = this.buffer.getPackedLong();
                int PARTIAL_JSON_UPDATES = 1;
                if ((valueOptions & (long)PARTIAL_JSON_UPDATES) != 0L) {
                    this.partialBits.set(1);
                    this.buffer.forward((this.jsonColumnCount + 7) / 8);
                }
            }
            this.nullBitIndex = 0;
            this.nullBits.clear();
            this.buffer.fillBitmap(this.nullBits, column);
        }
        return hasOneRow;
    }

    public final Serializable nextValue(String columName, int columnIndex, int type, int meta) {
        return this.nextValue(columName, columnIndex, type, meta, false);
    }

    public final Serializable nextValue(String columName, int columnIndex, int type, int meta, boolean isBinary) {
        this.fNull = this.nullBits.get(this.nullBitIndex++);
        if (this.fNull) {
            this.value = null;
            this.javaType = RowsLogBuffer.mysqlToJavaType(type, meta, isBinary);
            this.length = 0;
            return null;
        }
        return this.fetchValue(columName, columnIndex, type, meta, isBinary);
    }

    static int mysqlToJavaType(int type, int meta, boolean isBinary) {
        int javaType;
        if (type == 254 && meta >= 256) {
            int byte0 = meta >> 8;
            if ((byte0 & 0x30) != 48) {
                type = byte0 | 0x30;
            } else {
                switch (byte0) {
                    case 247: 
                    case 248: 
                    case 254: {
                        type = byte0;
                    }
                }
            }
        }
        switch (type) {
            case 3: {
                javaType = 4;
                break;
            }
            case 1: {
                javaType = -6;
                break;
            }
            case 2: {
                javaType = 5;
                break;
            }
            case 9: {
                javaType = 4;
                break;
            }
            case 8: {
                javaType = -5;
                break;
            }
            case 0: {
                javaType = 3;
                break;
            }
            case 246: {
                javaType = 3;
                break;
            }
            case 4: {
                javaType = 7;
                break;
            }
            case 5: {
                javaType = 8;
                break;
            }
            case 16: {
                javaType = -7;
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 18: {
                javaType = 93;
                break;
            }
            case 11: 
            case 19: {
                javaType = 92;
                break;
            }
            case 10: 
            case 14: {
                javaType = 91;
                break;
            }
            case 13: {
                javaType = 12;
                break;
            }
            case 247: {
                javaType = 4;
                break;
            }
            case 248: {
                javaType = -2;
                break;
            }
            case 249: 
            case 250: 
            case 251: 
            case 252: {
                if (meta == 1) {
                    javaType = -3;
                    break;
                }
                javaType = -4;
                break;
            }
            case 15: 
            case 253: {
                if (isBinary) {
                    javaType = -3;
                    break;
                }
                javaType = 12;
                break;
            }
            case 254: {
                if (isBinary) {
                    javaType = -2;
                    break;
                }
                javaType = 1;
                break;
            }
            case 255: {
                javaType = -2;
                break;
            }
            default: {
                javaType = 1111;
            }
        }
        return javaType;
    }

    /*
     * Unable to fully structure code
     */
    final Serializable fetchValue(String columnName, int columnIndex, int type, int meta, boolean isBinary) {
        len = 0;
        if (type == 254) {
            if (meta >= 256) {
                byte0 = meta >> 8;
                byte1 = meta & 255;
                if ((byte0 & 48) != 48) {
                    len = byte1 | (byte0 & 48 ^ 48) << 4;
                    type = byte0 | 48;
                } else {
                    switch (byte0) {
                        case 247: 
                        case 248: 
                        case 254: {
                            type = byte0;
                            len = byte1;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException(String.format("!! Don't know how to handle column type=%d meta=%d (%04X)", new Object[]{type, meta, meta}));
                        }
                    }
                }
            } else {
                len = meta;
            }
        }
        block3 : switch (type) {
            case 3: {
                this.value = Integer.valueOf(this.buffer.getInt32());
                this.javaType = 4;
                this.length = 4;
                break;
            }
            case 1: {
                this.value = Integer.valueOf(this.buffer.getInt8());
                this.javaType = -6;
                this.length = 1;
                break;
            }
            case 2: {
                this.value = Integer.valueOf((short)this.buffer.getInt16());
                this.javaType = 5;
                this.length = 2;
                break;
            }
            case 9: {
                this.value = Integer.valueOf(this.buffer.getInt24());
                this.javaType = 4;
                this.length = 3;
                break;
            }
            case 8: {
                this.value = Long.valueOf(this.buffer.getLong64());
                this.javaType = -5;
                this.length = 8;
                break;
            }
            case 0: {
                RowsLogBuffer.logger.warn((Object)"MYSQL_TYPE_DECIMAL : This enumeration value is only used internally and cannot exist in a binlog!");
                this.javaType = 3;
                this.value = null;
                this.length = 0;
                break;
            }
            case 246: {
                precision = meta >> 8;
                decimals = meta & 255;
                this.value = this.buffer.getDecimal(precision, decimals);
                this.javaType = 3;
                this.length = precision;
                break;
            }
            case 4: {
                this.value = Float.valueOf(this.buffer.getFloat32());
                this.javaType = 7;
                this.length = 4;
                break;
            }
            case 5: {
                this.value = Double.valueOf(this.buffer.getDouble64());
                this.javaType = 8;
                this.length = 8;
                break;
            }
            case 16: {
                nbits = (meta >> 8) * 8 + (meta & 255);
                len = (nbits + 7) / 8;
                if (nbits <= 1) ** GOTO lbl99
                switch (len) {
                    case 1: {
                        this.value = Integer.valueOf(this.buffer.getUint8());
                        ** GOTO lbl101
                    }
                    case 2: {
                        this.value = Integer.valueOf(this.buffer.getBeUint16());
                        ** GOTO lbl101
                    }
                    case 3: {
                        this.value = Integer.valueOf(this.buffer.getBeUint24());
                        ** GOTO lbl101
                    }
                    case 4: {
                        this.value = Long.valueOf(this.buffer.getBeUint32());
                        ** GOTO lbl101
                    }
                    case 5: {
                        this.value = Long.valueOf(this.buffer.getBeUlong40());
                        ** GOTO lbl101
                    }
                    case 6: {
                        this.value = Long.valueOf(this.buffer.getBeUlong48());
                        ** GOTO lbl101
                    }
                    case 7: {
                        this.value = Long.valueOf(this.buffer.getBeUlong56());
                        ** GOTO lbl101
                    }
                    case 8: {
                        this.value = this.buffer.getBeUlong64();
                        ** GOTO lbl101
                    }
                    default: {
                        throw new IllegalArgumentException("!! Unknown Bit len = " + len);
                    }
                }
lbl99:
                // 1 sources

                bit = this.buffer.getInt8();
                this.value = Integer.valueOf(bit);
lbl101:
                // 9 sources

                this.javaType = -7;
                this.length = nbits;
                break;
            }
            case 7: {
                i32 = this.buffer.getUint32();
                if (i32 == 0L) {
                    this.value = "0000-00-00 00:00:00";
                } else {
                    v = new Timestamp(i32 * 1000L).toString();
                    this.value = v.substring(0, v.length() - 2);
                }
                this.javaType = 93;
                this.length = 4;
                break;
            }
            case 17: {
                tv_sec = this.buffer.getBeUint32();
                tv_usec = 0;
                switch (meta) {
                    case 0: {
                        tv_usec = 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        tv_usec = this.buffer.getInt8() * 10000;
                        break;
                    }
                    case 3: 
                    case 4: {
                        tv_usec = this.buffer.getBeInt16() * 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        tv_usec = this.buffer.getBeInt24();
                        break;
                    }
                    default: {
                        tv_usec = 0;
                    }
                }
                second = null;
                if (tv_sec == 0L) {
                    second = "0000-00-00 00:00:00";
                } else {
                    time = new Timestamp(tv_sec * 1000L);
                    second = time.toString();
                    second = second.substring(0, second.length() - 2);
                }
                if (meta >= 1) {
                    microSecond = RowsLogBuffer.usecondsToStr(tv_usec, meta);
                    microSecond = microSecond.substring(0, meta);
                    this.value = second + '.' + microSecond;
                } else {
                    this.value = second;
                }
                this.javaType = 93;
                this.length = 4 + (meta + 1) / 2;
                break;
            }
            case 12: {
                i64 = this.buffer.getLong64();
                if (i64 == 0L) {
                    this.value = "0000-00-00 00:00:00";
                } else {
                    d = (int)(i64 / 1000000L);
                    t = (int)(i64 % 1000000L);
                    builder = new StringBuilder();
                    RowsLogBuffer.appendNumber4(builder, d / 10000);
                    builder.append('-');
                    RowsLogBuffer.appendNumber2(builder, d % 10000 / 100);
                    builder.append('-');
                    RowsLogBuffer.appendNumber2(builder, d % 100);
                    builder.append(' ');
                    RowsLogBuffer.appendNumber2(builder, t / 10000);
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, t % 10000 / 100);
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, t % 100);
                    this.value = builder.toString();
                }
                this.javaType = 93;
                this.length = 8;
                break;
            }
            case 18: {
                intpart = this.buffer.getBeUlong40() - 0x8000000000L;
                frac = 0;
                switch (meta) {
                    case 0: {
                        frac = 0;
                        break;
                    }
                    case 1: 
                    case 2: {
                        frac = this.buffer.getInt8() * 10000;
                        break;
                    }
                    case 3: 
                    case 4: {
                        frac = this.buffer.getBeInt16() * 100;
                        break;
                    }
                    case 5: 
                    case 6: {
                        frac = this.buffer.getBeInt24();
                        break;
                    }
                    default: {
                        frac = 0;
                    }
                }
                second = null;
                if (intpart == 0L) {
                    second = "0000-00-00 00:00:00";
                } else {
                    ymd = intpart >> 17;
                    ym = ymd >> 5;
                    hms = intpart % 131072L;
                    builder = new StringBuilder(26);
                    RowsLogBuffer.appendNumber4(builder, (int)(ym / 13L));
                    builder.append('-');
                    RowsLogBuffer.appendNumber2(builder, (int)(ym % 13L));
                    builder.append('-');
                    RowsLogBuffer.appendNumber2(builder, (int)(ymd % 32L));
                    builder.append(' ');
                    RowsLogBuffer.appendNumber2(builder, (int)(hms >> 12));
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, (int)((hms >> 6) % 64L));
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, (int)(hms % 64L));
                    second = builder.toString();
                }
                if (meta >= 1) {
                    microSecond = RowsLogBuffer.usecondsToStr(frac, meta);
                    microSecond = microSecond.substring(0, meta);
                    this.value = second + '.' + microSecond;
                } else {
                    this.value = second;
                }
                this.javaType = 93;
                this.length = 5 + (meta + 1) / 2;
                break;
            }
            case 11: {
                i32 = this.buffer.getInt24();
                u32 = Math.abs(i32);
                if (i32 == 0) {
                    this.value = "00:00:00";
                } else {
                    builder = new StringBuilder(17);
                    if (i32 < 0) {
                        builder.append('-');
                    }
                    if ((d = u32 / 10000) > 100) {
                        builder.append(String.valueOf(d));
                    } else {
                        RowsLogBuffer.appendNumber2(builder, d);
                    }
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, u32 % 10000 / 100);
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, u32 % 100);
                    this.value = builder.toString();
                }
                this.javaType = 92;
                this.length = 3;
                break;
            }
            case 19: {
                intpart = 0L;
                frac = 0;
                ltime = 0L;
                switch (meta) {
                    case 0: {
                        intpart = (long)this.buffer.getBeUint24() - 0x800000L;
                        ltime = intpart << 24;
                        break;
                    }
                    case 1: 
                    case 2: {
                        intpart = (long)this.buffer.getBeUint24() - 0x800000L;
                        frac = this.buffer.getUint8();
                        if (intpart < 0L && frac > 0) {
                            ++intpart;
                            frac -= 256;
                        }
                        frac *= 10000;
                        ltime = intpart << 24;
                        break;
                    }
                    case 3: 
                    case 4: {
                        intpart = (long)this.buffer.getBeUint24() - 0x800000L;
                        frac = this.buffer.getBeUint16();
                        if (intpart < 0L && frac > 0) {
                            ++intpart;
                            frac -= 65536;
                        }
                        frac *= 100;
                        ltime = intpart << 24;
                        break;
                    }
                    case 5: 
                    case 6: {
                        ltime = intpart = this.buffer.getBeUlong48() - 0x800000000000L;
                        frac = (int)(intpart % 0x1000000L);
                        break;
                    }
                    default: {
                        intpart = (long)this.buffer.getBeUint24() - 0x800000L;
                        ltime = intpart << 24;
                    }
                }
                second = null;
                if (intpart == 0L) {
                    second = "00:00:00";
                } else {
                    ultime = Math.abs(ltime);
                    intpart = ultime >> 24;
                    builder = new StringBuilder(12);
                    if (ltime < 0L) {
                        builder.append('-');
                    }
                    if ((d = (int)((intpart >> 12) % 1024L)) >= 100) {
                        builder.append(String.valueOf(d));
                    } else {
                        RowsLogBuffer.appendNumber2(builder, d);
                    }
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, (int)((intpart >> 6) % 64L));
                    builder.append(':');
                    RowsLogBuffer.appendNumber2(builder, (int)(intpart % 64L));
                    second = builder.toString();
                }
                if (meta >= 1) {
                    microSecond = RowsLogBuffer.usecondsToStr(Math.abs(frac), meta);
                    microSecond = microSecond.substring(0, meta);
                    this.value = second + '.' + microSecond;
                } else {
                    this.value = second;
                }
                this.javaType = 92;
                this.length = 3 + (meta + 1) / 2;
                break;
            }
            case 14: {
                RowsLogBuffer.logger.warn((Object)"MYSQL_TYPE_NEWDATE : This enumeration value is only used internally and cannot exist in a binlog!");
                this.javaType = 91;
                this.value = null;
                this.length = 0;
                break;
            }
            case 10: {
                i32 = this.buffer.getUint24();
                if (i32 == 0) {
                    this.value = "0000-00-00";
                } else {
                    builder = new StringBuilder(12);
                    RowsLogBuffer.appendNumber4(builder, i32 / 512);
                    builder.append('-');
                    RowsLogBuffer.appendNumber2(builder, i32 / 32 % 16);
                    builder.append('-');
                    RowsLogBuffer.appendNumber2(builder, i32 % 32);
                    this.value = builder.toString();
                }
                this.javaType = 91;
                this.length = 3;
                break;
            }
            case 13: {
                i32 = this.buffer.getUint8();
                this.value = i32 == 0 ? "0000" : String.valueOf((short)(i32 + 1900));
                this.javaType = 12;
                this.length = 1;
                break;
            }
            case 247: {
                switch (len) {
                    case 1: {
                        int32 = this.buffer.getUint8();
                        break;
                    }
                    case 2: {
                        int32 = this.buffer.getUint16();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("!! Unknown ENUM packlen = " + len);
                    }
                }
                this.value = Integer.valueOf(int32);
                this.javaType = 4;
                this.length = len;
                break;
            }
            case 248: {
                nbits = (meta & 255) * 8;
                len = (nbits + 7) / 8;
                if (nbits <= 1) ** GOTO lbl392
                switch (len) {
                    case 1: {
                        this.value = Integer.valueOf(this.buffer.getUint8());
                        ** GOTO lbl394
                    }
                    case 2: {
                        this.value = Integer.valueOf(this.buffer.getUint16());
                        ** GOTO lbl394
                    }
                    case 3: {
                        this.value = Integer.valueOf(this.buffer.getUint24());
                        ** GOTO lbl394
                    }
                    case 4: {
                        this.value = Long.valueOf(this.buffer.getUint32());
                        ** GOTO lbl394
                    }
                    case 5: {
                        this.value = Long.valueOf(this.buffer.getUlong40());
                        ** GOTO lbl394
                    }
                    case 6: {
                        this.value = Long.valueOf(this.buffer.getUlong48());
                        ** GOTO lbl394
                    }
                    case 7: {
                        this.value = Long.valueOf(this.buffer.getUlong56());
                        ** GOTO lbl394
                    }
                    case 8: {
                        this.value = this.buffer.getUlong64();
                        ** GOTO lbl394
                    }
                    default: {
                        throw new IllegalArgumentException("!! Unknown Set len = " + len);
                    }
                }
lbl392:
                // 1 sources

                bit = this.buffer.getInt8();
                this.value = Integer.valueOf(bit);
lbl394:
                // 9 sources

                this.javaType = -7;
                this.length = len;
                break;
            }
            case 249: {
                RowsLogBuffer.logger.warn((Object)"MYSQL_TYPE_TINY_BLOB : This enumeration value is only used internally and cannot exist in a binlog!");
            }
            case 250: {
                RowsLogBuffer.logger.warn((Object)"MYSQL_TYPE_MEDIUM_BLOB : This enumeration value is only used internally and cannot exist in a binlog!");
            }
            case 251: {
                RowsLogBuffer.logger.warn((Object)"MYSQL_TYPE_LONG_BLOB : This enumeration value is only used internally and cannot exist in a binlog!");
            }
            case 252: {
                switch (meta) {
                    case 1: {
                        len8 = this.buffer.getUint8();
                        binary = new byte[len8];
                        this.buffer.fillBytes(binary, 0, len8);
                        this.value = binary;
                        this.javaType = -3;
                        this.length = len8;
                        break block3;
                    }
                    case 2: {
                        len16 = this.buffer.getUint16();
                        binary = new byte[len16];
                        this.buffer.fillBytes(binary, 0, len16);
                        this.value = binary;
                        this.javaType = -4;
                        this.length = len16;
                        break block3;
                    }
                    case 3: {
                        len24 = this.buffer.getUint24();
                        binary = new byte[len24];
                        this.buffer.fillBytes(binary, 0, len24);
                        this.value = binary;
                        this.javaType = -4;
                        this.length = len24;
                        break block3;
                    }
                    case 4: {
                        len32 = (int)this.buffer.getUint32();
                        binary = new byte[len32];
                        this.buffer.fillBytes(binary, 0, len32);
                        this.value = binary;
                        this.javaType = -4;
                        this.length = len32;
                        break block3;
                    }
                }
                throw new IllegalArgumentException("!! Unknown BLOB packlen = " + meta);
            }
            case 15: 
            case 253: {
                len = meta;
                len = len < 256 ? this.buffer.getUint8() : this.buffer.getUint16();
                if (isBinary) {
                    binary = new byte[len];
                    this.buffer.fillBytes(binary, 0, len);
                    this.javaType = -3;
                    this.value = binary;
                } else {
                    this.value = this.buffer.getFullString(len, this.charsetName);
                    this.javaType = 12;
                }
                this.length = len;
                break;
            }
            case 254: {
                len = len < 256 ? this.buffer.getUint8() : this.buffer.getUint16();
                if (isBinary) {
                    binary = new byte[len];
                    this.buffer.fillBytes(binary, 0, len);
                    this.javaType = -2;
                    this.value = binary;
                } else {
                    this.value = this.buffer.getFullString(len, this.charsetName);
                    this.javaType = 1;
                }
                this.length = len;
                break;
            }
            case 245: {
                switch (meta) {
                    case 1: {
                        len = this.buffer.getUint8();
                        break;
                    }
                    case 2: {
                        len = this.buffer.getUint16();
                        break;
                    }
                    case 3: {
                        len = this.buffer.getUint24();
                        break;
                    }
                    case 4: {
                        len = (int)this.buffer.getUint32();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("!! Unknown JSON packlen = " + meta);
                    }
                }
                if (this.partialBits.get(1)) {
                    position = this.buffer.position();
                    builder = JsonDiffConversion.print_json_diff(this.buffer, len, columnName, columnIndex, this.charsetName);
                    this.value = builder.toString();
                    this.buffer.position(position + len);
                } else if (0 == len) {
                    this.value = "";
                } else {
                    position = this.buffer.position();
                    jsonValue = JsonConversion.parse_value(this.buffer.getUint8(), this.buffer, len - 1, this.charsetName);
                    builder = new StringBuilder();
                    jsonValue.toJsonString(builder, this.charsetName);
                    this.value = builder.toString();
                    this.buffer.position(position + len);
                }
                this.javaType = 12;
                this.length = len;
                break;
            }
            case 255: {
                switch (meta) {
                    case 1: {
                        len = this.buffer.getUint8();
                        break;
                    }
                    case 2: {
                        len = this.buffer.getUint16();
                        break;
                    }
                    case 3: {
                        len = this.buffer.getUint24();
                        break;
                    }
                    case 4: {
                        len = (int)this.buffer.getUint32();
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("!! Unknown MYSQL_TYPE_GEOMETRY packlen = " + meta);
                    }
                }
                binary = new byte[len];
                this.buffer.fillBytes(binary, 0, len);
                this.javaType = -2;
                this.value = binary;
                this.length = len;
                break;
            }
            default: {
                RowsLogBuffer.logger.error((Object)String.format("!! Don't know how to handle column type=%d meta=%d (%04X)", new Object[]{type, meta, meta}));
                this.javaType = 1111;
                this.value = null;
                this.length = 0;
            }
        }
        return this.value;
    }

    public final boolean isNull() {
        return this.fNull;
    }

    public final int getJavaType() {
        return this.javaType;
    }

    public final Serializable getValue() {
        return this.value;
    }

    public final int getLength() {
        return this.length;
    }

    public static String usecondsToStr(int frac, int meta) {
        String sec = String.valueOf(frac);
        if (meta > 6) {
            throw new IllegalArgumentException("unknow useconds meta : " + meta);
        }
        if (sec.length() < 6) {
            StringBuilder result = new StringBuilder(6);
            for (int len = 6 - sec.length(); len > 0; --len) {
                result.append('0');
            }
            result.append(sec);
            sec = result.toString();
        }
        return sec.substring(0, meta);
    }

    public static void appendNumber4(StringBuilder builder, int d) {
        if (d >= 1000) {
            builder.append(digits[d / 1000]).append(digits[d / 100 % 10]).append(digits[d / 10 % 10]).append(digits[d % 10]);
        } else {
            builder.append('0');
            RowsLogBuffer.appendNumber3(builder, d);
        }
    }

    public static void appendNumber3(StringBuilder builder, int d) {
        if (d >= 100) {
            builder.append(digits[d / 100]).append(digits[d / 10 % 10]).append(digits[d % 10]);
        } else {
            builder.append('0');
            RowsLogBuffer.appendNumber2(builder, d);
        }
    }

    public static void appendNumber2(StringBuilder builder, int d) {
        if (d >= 10) {
            builder.append(digits[d / 10 % 10]).append(digits[d % 10]);
        } else {
            builder.append('0').append(digits[d]);
        }
    }
}

