/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.driver.mysql;

import com.alibaba.otter.canal.parse.driver.mysql.MysqlConnector;
import com.alibaba.otter.canal.parse.driver.mysql.packets.client.QueryCommandPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.ErrorPacket;
import com.alibaba.otter.canal.parse.driver.mysql.packets.server.OKPacket;
import com.alibaba.otter.canal.parse.driver.mysql.utils.PacketManager;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlUpdateExecutor {
    private static final Logger logger = LoggerFactory.getLogger(MysqlUpdateExecutor.class);
    private MysqlConnector connector;

    public MysqlUpdateExecutor(MysqlConnector connector) throws IOException {
        if (!connector.isConnected()) {
            throw new IOException("should execute connector.connect() first");
        }
        this.connector = connector;
    }

    public OKPacket update(String updateString) throws IOException {
        QueryCommandPacket cmd = new QueryCommandPacket();
        cmd.setQueryString(updateString);
        byte[] bodyBytes = cmd.toBytes();
        PacketManager.writeBody(this.connector.getChannel(), bodyBytes);
        logger.debug("read update result...");
        byte[] body = PacketManager.readBytes(this.connector.getChannel(), PacketManager.readHeader(this.connector.getChannel(), 4).getPacketBodyLength());
        if (body[0] < 0) {
            ErrorPacket packet = new ErrorPacket();
            packet.fromBytes(body);
            throw new IOException(packet + "\n with command: " + updateString);
        }
        OKPacket packet = new OKPacket();
        packet.fromBytes(body);
        return packet;
    }
}

