/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.parse.inbound.mysql.dbsync;

import com.alibaba.otter.canal.parse.driver.mysql.socket.SocketChannel;
import com.taobao.tddl.dbsync.binlog.LogFetcher;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectLogFetcher
extends LogFetcher {
    protected static final Logger logger = LoggerFactory.getLogger(DirectLogFetcher.class);
    public static final int MASTER_HEARTBEAT_PERIOD_SECONDS = 15;
    private static final int READ_TIMEOUT_MILLISECONDS = 25000;
    public static final byte COM_BINLOG_DUMP = 18;
    public static final int NET_HEADER_SIZE = 4;
    public static final int SQLSTATE_LENGTH = 5;
    public static final int PACKET_LEN_OFFSET = 0;
    public static final int PACKET_SEQ_OFFSET = 3;
    public static final int MAX_PACKET_LENGTH = 0xFFFFFF;
    private SocketChannel channel;
    private boolean issemi = false;

    public DirectLogFetcher() {
        super(8192, 2.0f);
    }

    public DirectLogFetcher(int initialCapacity) {
        super(initialCapacity, 2.0f);
    }

    public DirectLogFetcher(int initialCapacity, float growthFactor) {
        super(initialCapacity, growthFactor);
    }

    public void start(SocketChannel channel) throws IOException {
        this.channel = channel;
        String dbsemi = System.getProperty("db.semi");
        if ("1".equals(dbsemi)) {
            this.issemi = true;
        }
    }

    public boolean fetch() throws IOException {
        try {
            if (!this.fetch0(0, 4)) {
                logger.warn("Reached end of input stream while fetching header");
                return false;
            }
            int netlen = this.getUint24(0);
            int netnum = this.getUint8(3);
            if (!this.fetch0(4, netlen)) {
                logger.warn("Reached end of input stream: packet #" + netnum + ", len = " + netlen);
                return false;
            }
            int mark = this.getUint8(4);
            if (mark != 0) {
                if (mark == 255) {
                    this.position = 5;
                    int errno = this.getInt16();
                    String sqlstate = this.forward(1).getFixString(5);
                    String errmsg = this.getFixString(this.limit - this.position);
                    throw new IOException("Received error packet: errno = " + errno + ", sqlstate = " + sqlstate + " errmsg = " + errmsg);
                }
                if (mark == 254) {
                    logger.warn("Received EOF packet from server, apparent master disconnected. It's may be duplicate slaveId , check instance config");
                    return false;
                }
                throw new IOException("Unexpected response " + mark + " while fetching binlog: packet #" + netnum + ", len = " + netlen);
            }
            if (this.issemi) {
                int semival;
                int semimark = this.getUint8(5);
                this.semival = semival = this.getUint8(6);
            }
            while (netlen == 0xFFFFFF) {
                if (!this.fetch0(0, 4)) {
                    logger.warn("Reached end of input stream while fetching header");
                    return false;
                }
                netlen = this.getUint24(0);
                netnum = this.getUint8(3);
                if (this.fetch0(this.limit, netlen)) continue;
                logger.warn("Reached end of input stream: packet #" + netnum + ", len = " + netlen);
                return false;
            }
            this.origin = this.issemi ? 7 : 5;
            this.position = this.origin;
            this.limit -= this.origin;
            return true;
        }
        catch (SocketTimeoutException e) {
            this.close();
            logger.error("Socket timeout expired, closing connection", (Throwable)e);
            throw e;
        }
        catch (InterruptedIOException e) {
            this.close();
            logger.info("I/O interrupted while reading from client socket", (Throwable)e);
            throw e;
        }
        catch (ClosedByInterruptException e) {
            this.close();
            logger.info("I/O interrupted while reading from client socket", (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            this.close();
            logger.error("I/O error while reading from client socket", (Throwable)e);
            throw e;
        }
    }

    private final boolean fetch0(int off, int len) throws IOException {
        this.ensureCapacity(off + len);
        this.channel.read(this.buffer, off, len, 25000);
        if (this.limit < off + len) {
            this.limit = off + len;
        }
        return true;
    }

    public void close() throws IOException {
    }
}

