/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.otter.canal.server;

import com.alibaba.otter.canal.connector.core.config.MQProperties;
import com.alibaba.otter.canal.connector.core.producer.MQDestination;
import com.alibaba.otter.canal.connector.core.spi.CanalMQProducer;
import com.alibaba.otter.canal.connector.core.util.Callback;
import com.alibaba.otter.canal.instance.core.CanalInstance;
import com.alibaba.otter.canal.instance.core.CanalMQConfig;
import com.alibaba.otter.canal.protocol.ClientIdentity;
import com.alibaba.otter.canal.protocol.Message;
import com.alibaba.otter.canal.server.embedded.CanalServerWithEmbedded;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class CanalMQStarter {
    private static final Logger logger = LoggerFactory.getLogger(CanalMQStarter.class);
    private volatile boolean running = false;
    private ExecutorService executorService;
    private CanalMQProducer canalMQProducer;
    private MQProperties mqProperties;
    private CanalServerWithEmbedded canalServer;
    private Map<String, CanalMQRunnable> canalMQWorks = new ConcurrentHashMap<String, CanalMQRunnable>();
    private static Thread shutdownThread = null;

    public CanalMQStarter(CanalMQProducer canalMQProducer) {
        this.canalMQProducer = canalMQProducer;
    }

    public synchronized void start(String destinations) {
        try {
            String[] dsts;
            if (this.running) {
                return;
            }
            this.mqProperties = this.canalMQProducer.getMqProperties();
            if (this.mqProperties.isFilterTransactionEntry()) {
                System.setProperty("canal.instance.filter.transaction.entry", "true");
            }
            this.canalServer = CanalServerWithEmbedded.instance();
            this.executorService = Executors.newCachedThreadPool();
            logger.info("## start the MQ workers.");
            for (String destination : dsts = StringUtils.split((String)destinations, (String)",")) {
                destination = destination.trim();
                CanalMQRunnable canalMQRunnable = new CanalMQRunnable(destination);
                this.canalMQWorks.put(destination, canalMQRunnable);
                this.executorService.execute(canalMQRunnable);
            }
            this.running = true;
            logger.info("## the MQ workers is running now ......");
            shutdownThread = new Thread(() -> {
                try {
                    logger.info("## stop the MQ workers");
                    this.running = false;
                    this.executorService.shutdown();
                    this.canalMQProducer.stop();
                }
                catch (Throwable e) {
                    logger.warn("##something goes wrong when stopping MQ workers:", e);
                }
                finally {
                    logger.info("## canal MQ is down.");
                }
            });
            Runtime.getRuntime().addShutdownHook(shutdownThread);
        }
        catch (Throwable e) {
            logger.error("## Something goes wrong when starting up the canal MQ workers:", e);
        }
    }

    public synchronized void destroy() {
        this.running = false;
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        if (this.canalMQProducer != null) {
            this.canalMQProducer.stop();
        }
        if (shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(shutdownThread);
            shutdownThread = null;
        }
    }

    public synchronized void startDestination(String destination) {
        CanalInstance canalInstance = this.canalServer.getCanalInstances().get(destination);
        if (canalInstance != null) {
            this.stopDestination(destination);
            CanalMQRunnable canalMQRunnable = new CanalMQRunnable(destination);
            this.canalMQWorks.put(canalInstance.getDestination(), canalMQRunnable);
            this.executorService.execute(canalMQRunnable);
            logger.info("## Start the MQ work of destination:" + destination);
        }
    }

    public synchronized void stopDestination(String destination) {
        CanalMQRunnable canalMQRunable = this.canalMQWorks.get(destination);
        if (canalMQRunable != null) {
            canalMQRunable.stop();
            this.canalMQWorks.remove(destination);
            logger.info("## Stop the MQ work of destination:" + destination);
        }
    }

    private void worker(String destination, AtomicBoolean destinationRunning) {
        while (!this.running || !destinationRunning.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        logger.info("## start the MQ producer: {}.", (Object)destination);
        MDC.put((String)"destination", (String)destination);
        final ClientIdentity clientIdentity = new ClientIdentity(destination, 1001, "");
        while (this.running && destinationRunning.get()) {
            try {
                CanalInstance canalInstance = this.canalServer.getCanalInstances().get(destination);
                if (canalInstance == null) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                MQDestination canalDestination = new MQDestination();
                canalDestination.setCanalDestination(destination);
                CanalMQConfig mqConfig = canalInstance.getMqConfig();
                canalDestination.setTopic(mqConfig.getTopic());
                canalDestination.setPartition(mqConfig.getPartition());
                canalDestination.setDynamicTopic(mqConfig.getDynamicTopic());
                canalDestination.setPartitionsNum(mqConfig.getPartitionsNum());
                canalDestination.setPartitionHash(mqConfig.getPartitionHash());
                canalDestination.setDynamicTopicPartitionNum(mqConfig.getDynamicTopicPartitionNum());
                this.canalServer.subscribe(clientIdentity);
                logger.info("## the MQ producer: {} is running now ......", (Object)destination);
                Integer getTimeout = this.mqProperties.getFetchTimeout();
                Integer getBatchSize = this.mqProperties.getBatchSize();
                while (this.running && destinationRunning.get()) {
                    Message message = getTimeout != null && getTimeout > 0 ? this.canalServer.getWithoutAck(clientIdentity, getBatchSize, getTimeout.longValue(), TimeUnit.MILLISECONDS) : this.canalServer.getWithoutAck(clientIdentity, getBatchSize);
                    final long batchId = message.getId();
                    try {
                        int size;
                        int n = size = message.isRaw() ? message.getRawEntries().size() : message.getEntries().size();
                        if (batchId != -1L && size != 0) {
                            this.canalMQProducer.send(canalDestination, message, new Callback(){

                                public void commit() {
                                    CanalMQStarter.this.canalServer.ack(clientIdentity, batchId);
                                }

                                public void rollback() {
                                    CanalMQStarter.this.canalServer.rollback(clientIdentity, batchId);
                                }
                            });
                            continue;
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                logger.error("process error!", (Throwable)e);
            }
        }
    }

    private class CanalMQRunnable
    implements Runnable {
        private String destination;
        private AtomicBoolean running = new AtomicBoolean(true);

        CanalMQRunnable(String destination) {
            this.destination = destination;
        }

        @Override
        public void run() {
            CanalMQStarter.this.worker(this.destination, this.running);
        }

        public void stop() {
            this.running.set(false);
        }
    }
}

