/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.common.model;

import com.alipay.sofa.registry.common.model.ServerDataBoxInputStream;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class ServerDataBox
implements Serializable {
    private static final long serialVersionUID = 2817539491173993030L;
    private static final int SERIALIZED_BY_JAVA = 1;
    private byte[] bytes;
    private int serialization;
    private Object object;

    public ServerDataBox() {
    }

    public ServerDataBox(Object object) {
        this.object = object;
    }

    public ServerDataBox(byte[] bytes) {
        this.bytes = bytes;
        this.serialization = 1;
    }

    @JsonIgnore
    public boolean isInBytes() {
        return this.bytes != null;
    }

    public Object getObject() {
        return this.object;
    }

    public Object extract() throws IOException, ClassNotFoundException {
        if (this.isInBytes()) {
            ByteArrayInputStream bis = new ByteArrayInputStream(this.bytes);
            if (this.serialization != 1) {
                throw new IOException("Unsupported serialization type: " + this.serialization);
            }
            try (ServerDataBoxInputStream input = null;){
                input = new ServerDataBoxInputStream(bis);
                this.object = input.readObject();
            }
        }
        return this.object;
    }

    public ServerDataBox object2bytes() {
        if (!this.isInBytes()) {
            this.bytes = ServerDataBox.getBytes(this.object);
            this.serialization = 1;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytes(Object object) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream javaos = null;
        try {
            javaos = new ObjectOutputStream(bos);
            javaos.writeObject(object);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (null != javaos) {
                    javaos.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bos.toByteArray();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.serialization = in.readByte();
        int size = in.readInt();
        this.bytes = new byte[size];
        in.readFully(this.bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.isInBytes()) {
            out.writeByte(this.serialization);
            out.writeInt(this.bytes.length);
            out.write(this.bytes);
        } else {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream javaos = new ObjectOutputStream(bos);
            try {
                javaos.writeObject(this.object);
            }
            finally {
                try {
                    javaos.close();
                }
                catch (IOException iOException) {}
            }
            out.writeByte(1);
            out.writeInt(bos.size());
            out.write(bos.toByteArray());
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getSerialization() {
        return this.serialization;
    }

    public void setSerialization(int serial) {
        this.serialization = serial;
    }
}

