/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.listener;

import com.alipay.sofa.registry.common.model.Node;
import com.alipay.sofa.registry.server.meta.bootstrap.MetaServerConfig;
import com.alipay.sofa.registry.server.meta.task.DataNodeChangePushTask;
import com.alipay.sofa.registry.server.meta.task.MetaServerTask;
import com.alipay.sofa.registry.task.batcher.TaskDispatcher;
import com.alipay.sofa.registry.task.batcher.TaskDispatchers;
import com.alipay.sofa.registry.task.batcher.TaskProcessor;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListener;
import org.springframework.beans.factory.annotation.Autowired;

public class DataNodeChangePushTaskListener
implements TaskListener {
    private TaskDispatcher<String, MetaServerTask> dataSingleTaskDispatcher;
    private TaskDispatcher<String, MetaServerTask> sessionSingleTaskDispatcher;
    @Autowired
    private MetaServerConfig metaServerConfig;

    public DataNodeChangePushTaskListener(TaskProcessor dataNodeSingleTaskProcessor) {
        this.dataSingleTaskDispatcher = TaskDispatchers.createDefaultSingleTaskDispatcher((String)(TaskEvent.TaskType.DATA_NODE_CHANGE_PUSH_TASK.getName() + "Data"), (TaskProcessor)dataNodeSingleTaskProcessor);
        this.sessionSingleTaskDispatcher = TaskDispatchers.createDefaultSingleTaskDispatcher((String)(TaskEvent.TaskType.DATA_NODE_CHANGE_PUSH_TASK.getName() + "Session"), (TaskProcessor)dataNodeSingleTaskProcessor);
    }

    public boolean support(TaskEvent event) {
        return TaskEvent.TaskType.DATA_NODE_CHANGE_PUSH_TASK.equals((Object)event.getTaskType());
    }

    public void handleEvent(TaskEvent event) {
        Node.NodeType nodeType = (Node.NodeType)event.getAttribute("PUSH_TARGET_TYPE");
        switch (nodeType) {
            case SESSION: {
                DataNodeChangePushTask sessionNodeChangePushTask = new DataNodeChangePushTask(Node.NodeType.SESSION, this.metaServerConfig);
                sessionNodeChangePushTask.setTaskEvent(event);
                this.sessionSingleTaskDispatcher.dispatch((Object)sessionNodeChangePushTask.getTaskId(), (Object)sessionNodeChangePushTask, sessionNodeChangePushTask.getExpiryTime());
                break;
            }
            case DATA: {
                DataNodeChangePushTask dataNodeChangePushTask = new DataNodeChangePushTask(Node.NodeType.DATA, this.metaServerConfig);
                dataNodeChangePushTask.setTaskEvent(event);
                this.dataSingleTaskDispatcher.dispatch((Object)dataNodeChangePushTask.getTaskId(), (Object)dataNodeChangePushTask, dataNodeChangePushTask.getExpiryTime());
                break;
            }
        }
    }
}

