/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.registry.server.meta.resource;

import com.alipay.sofa.registry.common.model.console.PersistenceData;
import com.alipay.sofa.registry.common.model.metaserver.DataOperator;
import com.alipay.sofa.registry.common.model.metaserver.NotifyProvideDataChange;
import com.alipay.sofa.registry.common.model.store.DataInfo;
import com.alipay.sofa.registry.core.model.Result;
import com.alipay.sofa.registry.log.Logger;
import com.alipay.sofa.registry.log.LoggerFactory;
import com.alipay.sofa.registry.store.api.DBService;
import com.alipay.sofa.registry.store.api.annotation.RaftReference;
import com.alipay.sofa.registry.task.listener.TaskEvent;
import com.alipay.sofa.registry.task.listener.TaskListenerManager;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;

@Path(value="persistentData")
public class PersistentDataResource {
    private static final Logger DB_LOGGER = LoggerFactory.getLogger(PersistentDataResource.class, (String)"[DBService]");
    private static final Logger taskLogger = LoggerFactory.getLogger(PersistentDataResource.class, (String)"[Task]");
    @RaftReference
    private DBService persistenceDataDBService;
    @Autowired
    private TaskListenerManager taskListenerManager;

    @POST
    @Path(value="put")
    @Produces(value={"application/json"})
    public Result put(PersistenceData data) {
        this.checkObj(data, "PersistenceData");
        this.checkString(data.getData());
        this.checkObj(data.getVersion(), "version");
        String dataInfoId = DataInfo.toDataInfoId((String)data.getDataId(), (String)data.getInstanceId(), (String)data.getGroup());
        try {
            boolean ret = this.persistenceDataDBService.put(dataInfoId, (Object)data);
            DB_LOGGER.info("put Persistence Data {} to DB result {}!", (Object)data, (Object)ret);
        }
        catch (Exception e) {
            DB_LOGGER.error("error put Persistence Data {} to DB!", (Object)data);
            throw new RuntimeException("Put Persistence Data " + data + " to DB error!");
        }
        this.fireDataChangeNotify(data.getVersion(), dataInfoId, DataOperator.ADD);
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    @POST
    @Path(value="remove")
    @Produces(value={"application/json"})
    public Result remove(PersistenceData data) {
        this.checkObj(data, "PersistenceData");
        this.checkObj(data.getVersion(), "version");
        String dataInfoId = DataInfo.toDataInfoId((String)data.getDataId(), (String)data.getInstanceId(), (String)data.getGroup());
        try {
            boolean ret = this.persistenceDataDBService.remove(dataInfoId);
            DB_LOGGER.info("remove Persistence Data {} from DB result {}!", (Object)data, (Object)ret);
        }
        catch (Exception e) {
            DB_LOGGER.error("error remove Persistence Data {} from DB!", (Object)data);
            throw new RuntimeException("Remove Persistence Data " + data + " from DB error!");
        }
        this.fireDataChangeNotify(data.getVersion(), dataInfoId, DataOperator.REMOVE);
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }

    private void fireDataChangeNotify(Long version, String dataInfoId, DataOperator dataOperator) {
        NotifyProvideDataChange notifyProvideDataChange = new NotifyProvideDataChange(dataInfoId, version, dataOperator);
        TaskEvent taskEvent = new TaskEvent((Object)notifyProvideDataChange, TaskEvent.TaskType.PERSISTENCE_DATA_CHANGE_NOTIFY_TASK);
        taskLogger.info("send PERSISTENCE_DATA_CHANGE_NOTIFY_TASK notifyProvideDataChange:" + notifyProvideDataChange);
        this.taskListenerManager.sendTaskEvent(taskEvent);
    }

    private void checkString(String input) {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("Error String data input:" + input);
        }
    }

    private void checkObj(Object input, String objName) {
        if (input == null) {
            throw new IllegalArgumentException("Error null Object " + objName + " data input!");
        }
    }
}

