/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials;

import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.DefaultCredentialsProvider;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RsaKeyPairCredentialProvider;
import com.aliyun.credentials.provider.StaticCredentialsProvider;
import com.aliyun.credentials.provider.URLCredentialProvider;
import com.aliyun.tea.utils.Validate;

public class Client {
    private final AlibabaCloudCredentialsProvider credentialsProvider;

    public Client() {
        this.credentialsProvider = new DefaultCredentialsProvider();
    }

    public Client(Config config) {
        this.credentialsProvider = null == config ? new DefaultCredentialsProvider() : this.getProvider(config);
    }

    public Client(AlibabaCloudCredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    private AlibabaCloudCredentialsProvider getProvider(Config config) {
        try {
            switch (config.type) {
                case "access_key": {
                    return StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId((String)Validate.notNull((Object)config.accessKeyId, (String)"AccessKeyId must not be null.", (Object[])new Object[0])).accessKeySecret((String)Validate.notNull((Object)config.accessKeySecret, (String)"AccessKeySecret must not be null.", (Object[])new Object[0])).type(config.type).build()).build();
                }
                case "sts": {
                    return StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId((String)Validate.notNull((Object)config.accessKeyId, (String)"AccessKeyId must not be null.", (Object[])new Object[0])).accessKeySecret((String)Validate.notNull((Object)config.accessKeySecret, (String)"AccessKeySecret must not be null.", (Object[])new Object[0])).securityToken((String)Validate.notNull((Object)config.securityToken, (String)"SecurityToken must not be null.", (Object[])new Object[0])).type(config.type).build()).build();
                }
                case "bearer": {
                    return StaticCredentialsProvider.builder().credential(CredentialModel.builder().bearerToken((String)Validate.notNull((Object)config.bearerToken, (String)"BearerToken must not be null.", (Object[])new Object[0])).type(config.type).build()).build();
                }
                case "ecs_ram_role": {
                    return EcsRamRoleCredentialProvider.builder().roleName(config.roleName).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
                }
                case "ram_role_arn": {
                    return RamRoleArnCredentialProvider.builder().accessKeyId(config.accessKeyId).accessKeySecret(config.accessKeySecret).durationSeconds(config.roleSessionExpiration).roleArn(config.roleArn).roleSessionName(config.roleSessionName).policy(config.policy).STSEndpoint(config.STSEndpoint).externalId(config.externalId).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
                }
                case "rsa_key_pair": {
                    return RsaKeyPairCredentialProvider.builder().publicKeyId(config.publicKeyId).privateKeyFile(config.privateKeyFile).durationSeconds(config.roleSessionExpiration).STSEndpoint(config.STSEndpoint).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
                }
                case "oidc_role_arn": {
                    return OIDCRoleArnCredentialProvider.builder().durationSeconds(config.roleSessionExpiration).roleArn(config.roleArn).roleSessionName(config.roleSessionName).oidcProviderArn(config.oidcProviderArn).oidcTokenFilePath(config.oidcTokenFilePath).policy(config.policy).STSEndpoint(config.STSEndpoint).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
                }
                case "credentials_uri": {
                    return URLCredentialProvider.builder().credentialsURI(config.credentialsURI).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new DefaultCredentialsProvider();
    }

    public String getAccessKeyId() {
        return this.credentialsProvider.getCredentials().getAccessKeyId();
    }

    public String getAccessKeySecret() {
        return this.credentialsProvider.getCredentials().getAccessKeySecret();
    }

    public String getSecurityToken() {
        return this.credentialsProvider.getCredentials().getSecurityToken();
    }

    public String getType() {
        return this.credentialsProvider.getCredentials().getType();
    }

    public String getBearerToken() {
        return this.credentialsProvider.getCredentials().getBearerToken();
    }

    public CredentialModel getCredential() {
        return this.credentialsProvider.getCredentials();
    }
}

