/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.phoenix.shaded.org.apache.calcite.avatica.remote;

import com.aliyun.calcite.avatica.org.apache.http.NoHttpResponseException;
import com.aliyun.calcite.avatica.org.apache.http.client.ClientProtocolException;
import com.aliyun.calcite.avatica.org.apache.http.client.config.RequestConfig;
import com.aliyun.calcite.avatica.org.apache.http.client.methods.CloseableHttpResponse;
import com.aliyun.calcite.avatica.org.apache.http.client.methods.HttpPost;
import com.aliyun.calcite.avatica.org.apache.http.client.protocol.HttpClientContext;
import com.aliyun.calcite.avatica.org.apache.http.entity.ByteArrayEntity;
import com.aliyun.calcite.avatica.org.apache.http.entity.ContentType;
import com.aliyun.calcite.avatica.org.apache.http.util.EntityUtils;
import com.aliyun.phoenix.shaded.org.apache.calcite.avatica.remote.AvaticaCommonsHttpClientImpl;
import com.aliyun.phoenix.shaded.org.apache.calcite.avatica.remote.AvaticaHttpClient;
import com.aliyun.phoenix.shaded.org.slf4j.Logger;
import com.aliyun.phoenix.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.util.Properties;

public class PhoenixHttpClient
implements AvaticaHttpClient {
    private static final Logger LOG = LoggerFactory.getLogger(PhoenixHttpClient.class);
    private Properties connectionInfo = null;
    private AvaticaCommonsHttpClientImpl client = null;
    private final int connectTimeout;
    private final int connectionRequestTimeout;
    private final int socketTimeout;

    public PhoenixHttpClient(Properties connectionInfo, AvaticaCommonsHttpClientImpl client) {
        this.connectionInfo = connectionInfo;
        this.client = client;
        this.connectTimeout = Integer.parseInt(connectionInfo.getProperty("phoenix.thin.driver.connect.timeout", "60000"));
        this.connectionRequestTimeout = Integer.parseInt(connectionInfo.getProperty("phoenix.thin.driver.connection.request.timeout", "60000"));
        this.socketTimeout = Integer.parseInt(connectionInfo.getProperty("phoenix.thin.driver.socket.timeout", "-1"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] send(byte[] request) {
        while (true) {
            HttpClientContext context = HttpClientContext.create();
            context.setTargetHost(this.client.host);
            if (null != this.client.credentials) {
                context.setCredentialsProvider(this.client.credentialsProvider);
                context.setAuthSchemeRegistry(this.client.authRegistry);
                context.setAuthCache(this.client.authCache);
            }
            ByteArrayEntity entity = new ByteArrayEntity(request, ContentType.APPLICATION_OCTET_STREAM);
            HttpPost post = new HttpPost(this.client.uri);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.connectTimeout).setConnectionRequestTimeout(this.connectionRequestTimeout).setSocketTimeout(this.socketTimeout).build();
            post.setConfig(requestConfig);
            post.setEntity(entity);
            try {
                CloseableHttpResponse response = this.execute(post, context);
                Throwable throwable = null;
                try {
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (200 == statusCode || 500 == statusCode) {
                        byte[] byArray = EntityUtils.toByteArray(response.getEntity());
                        return byArray;
                    }
                    if (503 != statusCode) throw new RuntimeException("Failed to execute HTTP Request, got HTTP/" + statusCode);
                    LOG.debug("Failed to connect to server (HTTP/503), retrying");
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (response == null) continue;
                    if (throwable != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    response.close();
                    continue;
                }
            }
            catch (NoHttpResponseException e) {
                LOG.debug("The server failed to issue an HTTP response, retrying");
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.debug("Failed to execute HTTP request", e);
                throw new RuntimeException(e);
            }
            break;
        }
    }

    CloseableHttpResponse execute(HttpPost post, HttpClientContext context) throws IOException, ClientProtocolException {
        return this.client.execute(post, context);
    }
}

