/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.time.format.DateTimeFormatter;
import java.util.Properties;
import org.slf4j.helpers.Util;
import org.slf4j.impl.OutputChoice;

public class SimpleLoggerConfiguration {
    private static final String CONFIGURATION_FILE = "app.properties";
    static int DEFAULT_LOG_LEVEL_DEFAULT = 20;
    int defaultLogLevel = DEFAULT_LOG_LEVEL_DEFAULT;
    private static final boolean SHOW_DATE_TIME_DEFAULT = true;
    boolean showDateTime = true;
    private static final String DATE_TIME_FORMAT_STR_DEFAULT = "yyyy-MM-dd HH:mm:ss:SSS";
    private static String dateTimeFormatStr = "yyyy-MM-dd HH:mm:ss:SSS";
    DateTimeFormatter dateFormatter = null;
    private static final boolean SHOW_THREAD_NAME_DEFAULT = true;
    boolean showThreadName = true;
    static final boolean SHOW_LOG_NAME_DEFAULT = true;
    boolean showLogName = true;
    private static final boolean SHOW_SHORT_LOG_NAME_DEFAULT = true;
    boolean showShortLogName = true;
    private static final boolean LEVEL_IN_BRACKETS_DEFAULT = false;
    boolean levelInBrackets = false;
    private static String LOG_FILE_DEFAULT = "System.out";
    private String logFile = LOG_FILE_DEFAULT;
    OutputChoice outputChoice = null;
    private static final boolean CACHE_OUTPUT_STREAM_DEFAULT = false;
    private boolean cacheOutputStream = false;
    private static final String WARN_LEVELS_STRING_DEFAULT = "WARN";
    String warnLevelString = "WARN";
    private final Properties properties = new Properties();

    void init() {
        this.loadProperties();
        String defaultLogLevelString = this.getStringProperty("com.blade.logger.defaultLogLevel", null);
        if (defaultLogLevelString != null) {
            this.defaultLogLevel = SimpleLoggerConfiguration.stringToLevel(defaultLogLevelString);
        }
        this.showLogName = this.getBooleanProperty("com.blade.logger.showLogName", true);
        this.showShortLogName = this.getBooleanProperty("com.blade.logger.showShortLogName", true);
        this.showDateTime = this.getBooleanProperty("com.blade.logger.showDateTime", true);
        this.showThreadName = this.getBooleanProperty("com.blade.logger.showThreadName", true);
        dateTimeFormatStr = this.getStringProperty("com.blade.logger.dateTimeFormat", DATE_TIME_FORMAT_STR_DEFAULT);
        this.levelInBrackets = this.getBooleanProperty("com.blade.logger.levelInBrackets", false);
        this.warnLevelString = this.getStringProperty("com.blade.logger.warnLevelString", WARN_LEVELS_STRING_DEFAULT);
        this.logFile = this.getStringProperty("com.blade.logger.logFile", this.logFile);
        this.cacheOutputStream = this.getBooleanProperty("com.blade.logger.cacheOutputStream", false);
        this.outputChoice = SimpleLoggerConfiguration.computeOutputChoice(this.logFile, this.cacheOutputStream);
        if (dateTimeFormatStr != null) {
            try {
                this.dateFormatter = DateTimeFormatter.ofPattern(dateTimeFormatStr);
            }
            catch (IllegalArgumentException e) {
                Util.report((String)"Bad date format in app.properties; will output relative time", (Throwable)e);
            }
        }
    }

    private void loadProperties() {
        InputStream in = AccessController.doPrivileged(() -> {
            ClassLoader threadCL = Thread.currentThread().getContextClassLoader();
            if (threadCL != null) {
                return threadCL.getResourceAsStream(CONFIGURATION_FILE);
            }
            return ClassLoader.getSystemResourceAsStream(CONFIGURATION_FILE);
        });
        if (null != in) {
            try {
                this.properties.load(in);
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    String getStringProperty(String name, String defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : prop;
    }

    boolean getBooleanProperty(String name, boolean defaultValue) {
        String prop = this.getStringProperty(name);
        return prop == null ? defaultValue : "true".equalsIgnoreCase(prop);
    }

    String getStringProperty(String name) {
        String prop = null;
        try {
            prop = System.getProperty(name);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return prop == null ? this.properties.getProperty(name) : prop;
    }

    static int stringToLevel(String levelStr) {
        if ("trace".equalsIgnoreCase(levelStr)) {
            return 0;
        }
        if ("debug".equalsIgnoreCase(levelStr)) {
            return 10;
        }
        if ("info".equalsIgnoreCase(levelStr)) {
            return 20;
        }
        if ("warn".equalsIgnoreCase(levelStr)) {
            return 30;
        }
        if ("error".equalsIgnoreCase(levelStr)) {
            return 40;
        }
        if ("off".equalsIgnoreCase(levelStr)) {
            return 50;
        }
        return 20;
    }

    private static OutputChoice computeOutputChoice(String logFile, boolean cacheOutputStream) {
        if ("System.err".equalsIgnoreCase(logFile)) {
            if (cacheOutputStream) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_ERR);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_ERR);
        }
        if ("System.out".equalsIgnoreCase(logFile)) {
            if (cacheOutputStream) {
                return new OutputChoice(OutputChoice.OutputChoiceType.CACHED_SYS_OUT);
            }
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_OUT);
        }
        try {
            if (!new File(logFile).getParentFile().exists()) {
                new File(logFile).getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(logFile);
            PrintStream printStream = new PrintStream(fos);
            return new OutputChoice(printStream);
        }
        catch (FileNotFoundException e) {
            Util.report((String)("Could not open [" + logFile + "]. Defaulting to System.err"), (Throwable)e);
            return new OutputChoice(OutputChoice.OutputChoiceType.SYS_ERR);
        }
    }
}

