/*
 * Decompiled with CFR 0.152.
 */
package com.blade;

import com.blade.Environment;
import com.blade.event.BeanProcessor;
import com.blade.event.EventListener;
import com.blade.event.EventManager;
import com.blade.event.EventType;
import com.blade.ioc.Ioc;
import com.blade.ioc.SimpleIoc;
import com.blade.kit.Assert;
import com.blade.kit.BladeKit;
import com.blade.mvc.Const;
import com.blade.mvc.SessionManager;
import com.blade.mvc.handler.DefaultExceptionHandler;
import com.blade.mvc.handler.ExceptionHandler;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.HttpMethod;
import com.blade.mvc.http.HttpSession;
import com.blade.mvc.http.Session;
import com.blade.mvc.route.RouteMatcher;
import com.blade.mvc.ui.template.DefaultEngine;
import com.blade.mvc.ui.template.TemplateEngine;
import com.blade.server.netty.NettyServer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blade {
    private static final Logger log = LoggerFactory.getLogger(Blade.class);
    private List<WebHook> middleware = new ArrayList<WebHook>();
    private List<BeanProcessor> processors = new ArrayList<BeanProcessor>();
    private Set<String> packages = new LinkedHashSet<String>(Const.PLUGIN_PACKAGE_NAME);
    private Set<String> statics = new HashSet<String>(Const.DEFAULT_STATICS);
    private Ioc ioc = new SimpleIoc();
    private TemplateEngine templateEngine = new DefaultEngine();
    private EventManager eventManager = new EventManager();
    private SessionManager sessionManager = new SessionManager();
    private CountDownLatch latch = new CountDownLatch(1);
    private NettyServer nettyServer = new NettyServer();
    private RouteMatcher routeMatcher = new RouteMatcher();
    private Environment environment = Environment.empty();
    private Consumer<Exception> startupExceptionHandler = e -> log.error("Start blade failed", (Throwable)e);
    private ExceptionHandler exceptionHandler = new DefaultExceptionHandler();
    private boolean started = false;
    private Class<?> bootClass = null;
    private Class<? extends Session> sessionImplType = HttpSession.class;

    public static Blade me() {
        return new Blade();
    }

    public Ioc ioc() {
        return this.ioc;
    }

    public Blade get(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.GET);
        return this;
    }

    public Blade post(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.POST);
        return this;
    }

    public Blade put(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.PUT);
        return this;
    }

    public Blade delete(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.DELETE);
        return this;
    }

    public Blade before(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.BEFORE);
        return this;
    }

    public Blade after(@NonNull String path, @NonNull RouteHandler handler) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.routeMatcher.addRoute(path, handler, HttpMethod.AFTER);
        return this;
    }

    public Blade templateEngine(@NonNull TemplateEngine templateEngine) {
        if (templateEngine == null) {
            throw new NullPointerException("templateEngine");
        }
        this.templateEngine = templateEngine;
        return this;
    }

    public TemplateEngine templateEngine() {
        return this.templateEngine;
    }

    public RouteMatcher routeMatcher() {
        return this.routeMatcher;
    }

    public Blade register(@NonNull Object bean) {
        if (bean == null) {
            throw new NullPointerException("bean");
        }
        this.ioc.addBean(bean);
        return this;
    }

    public Blade register(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        this.ioc.addBean(cls);
        return this;
    }

    public Blade addStatics(String ... folders) {
        if (folders == null) {
            throw new NullPointerException("folders");
        }
        this.statics.addAll(Arrays.asList(folders));
        return this;
    }

    public Blade showFileList(boolean fileList) {
        this.environment("mvc.statics.show-list", fileList);
        return this;
    }

    public Blade gzip(boolean gzipEnable) {
        this.environment("http.gzip.enable", gzipEnable);
        return this;
    }

    public Object getBean(@NonNull Class<?> cls) {
        if (cls == null) {
            throw new NullPointerException("cls");
        }
        return this.ioc.getBean(cls);
    }

    public ExceptionHandler exceptionHandler() {
        return this.exceptionHandler;
    }

    public Blade exceptionHandler(ExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    public boolean devMode() {
        return this.environment.getBoolean("app.devMode", true);
    }

    public Blade devMode(boolean devMode) {
        this.environment("app.devMode", devMode);
        return this;
    }

    public Class<?> bootClass() {
        return this.bootClass;
    }

    public Blade enableCors(boolean enableCors) {
        this.environment("http.cors.enable", enableCors);
        return this;
    }

    public Set<String> getStatics() {
        return this.statics;
    }

    public Blade scanPackages(String ... packages) {
        if (packages == null) {
            throw new NullPointerException("packages");
        }
        this.packages.addAll(Arrays.asList(packages));
        return this;
    }

    public Set<String> scanPackages() {
        return this.packages;
    }

    public Blade bootConf(@NonNull String bootConf) {
        if (bootConf == null) {
            throw new NullPointerException("bootConf");
        }
        this.environment("boot_conf", bootConf);
        return this;
    }

    public Blade environment(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.environment.set(key, value);
        return this;
    }

    public Environment environment() {
        return this.environment;
    }

    public Blade listen(int port) {
        Assert.greaterThan(port, 0.0, "server port not is negative number.");
        this.environment("server.port", port);
        return this;
    }

    public Blade listen(@NonNull String address, int port) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        Assert.greaterThan(port, 0.0, "server port not is negative number.");
        this.environment("server.address", address);
        this.environment("server.port", port);
        return this;
    }

    public Blade use(WebHook ... middleware) {
        if (middleware == null) {
            throw new NullPointerException("middleware");
        }
        if (!BladeKit.isEmpty(middleware)) {
            this.middleware.addAll(Arrays.asList(middleware));
        }
        return this;
    }

    public List<WebHook> middleware() {
        return this.middleware;
    }

    public Blade appName(@NonNull String appName) {
        if (appName == null) {
            throw new NullPointerException("appName");
        }
        this.environment("app.name", appName);
        return this;
    }

    public Blade event(@NonNull EventType eventType, @NonNull EventListener eventListener) {
        if (eventType == null) {
            throw new NullPointerException("eventType");
        }
        if (eventListener == null) {
            throw new NullPointerException("eventListener");
        }
        this.eventManager.addEventListener(eventType, eventListener);
        return this;
    }

    public Class<? extends Session> sessionType() {
        return this.sessionImplType;
    }

    public Blade sessionType(Class<? extends Session> sessionImplType) {
        this.sessionImplType = sessionImplType;
        return this;
    }

    public Blade onStarted(@NonNull BeanProcessor processor) {
        if (processor == null) {
            throw new NullPointerException("processor");
        }
        this.processors.add(processor);
        return this;
    }

    public List<BeanProcessor> processors() {
        return this.processors;
    }

    public EventManager eventManager() {
        return this.eventManager;
    }

    public SessionManager sessionManager() {
        return this.sessionManager;
    }

    public Blade disableSession() {
        this.sessionManager = null;
        return this;
    }

    public Blade start() {
        return this.start(null, null);
    }

    public Blade start(Class<?> mainCls, String ... args) {
        return this.start(mainCls, "0.0.0.0", 9000, args);
    }

    public Blade start(Class<?> bootClass, @NonNull String address, int port, String ... args) {
        if (address == null) {
            throw new NullPointerException("address");
        }
        try {
            this.environment.set("server.address", address);
            Assert.greaterThan(port, 0.0, "server port not is negative number.");
            this.bootClass = bootClass;
            this.eventManager.fireEvent(EventType.SERVER_STARTING, this);
            Thread thread = new Thread(() -> {
                try {
                    this.nettyServer.start(this, args);
                    this.latch.countDown();
                    this.nettyServer.join();
                }
                catch (Exception e) {
                    this.startupExceptionHandler.accept(e);
                }
            });
            thread.setName("_(:3\u300d\u2220)_");
            thread.start();
            this.started = true;
        }
        catch (Exception e) {
            this.startupExceptionHandler.accept(e);
        }
        return this;
    }

    public Blade await() {
        if (!this.started) {
            throw new IllegalStateException("Server hasn't been started. Call start() before calling this method.");
        }
        try {
            this.latch.await();
        }
        catch (Exception e) {
            log.error("await error", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public void stop() {
        this.eventManager.fireEvent(EventType.SERVER_STOPPING, this);
        this.nettyServer.stopAndWait();
        this.eventManager.fireEvent(EventType.SERVER_STOPPED, this);
    }

    private Blade() {
    }
}

