/*
 * Decompiled with CFR 0.152.
 */
package com.blade.event;

import com.blade.Blade;
import com.blade.event.Event;
import com.blade.event.EventListener;
import com.blade.event.EventType;
import com.blade.ioc.OrderComparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EventManager {
    private Map<EventType, List<EventListener>> listenerMap = null;
    private OrderComparator<EventListener> comparator = new OrderComparator();

    public EventManager() {
        this.listenerMap = Stream.of(EventType.values()).collect(Collectors.toMap(v -> v, v -> new LinkedList()));
    }

    public void addEventListener(EventType type, EventListener listener) {
        this.listenerMap.get((Object)type).add(listener);
    }

    public void fireEvent(EventType type, Blade blade) {
        this.listenerMap.get((Object)type).stream().sorted(this.comparator).forEach(listener -> listener.trigger(new Event(type, blade)));
    }

    void fireEvent(EventType type) {
        this.fireEvent(type, null);
    }
}

