/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.json.Ason;
import com.blade.kit.json.BeanSerializer;
import com.blade.kit.json.JsonSerializer;
import com.blade.kit.json.SerializeMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonKit {
    private static final Logger log = LoggerFactory.getLogger(JsonKit.class);

    public static String toString(Object object) {
        return JsonKit.toString(object, SerializeMapping.defaultMapping());
    }

    public static String toString(Object object, SerializeMapping serializeMapping) {
        try {
            Object jsonObj = BeanSerializer.serialize(serializeMapping, object);
            return JsonSerializer.serialize(jsonObj);
        }
        catch (Exception e) {
            log.error("object to json string error", (Throwable)e);
            return null;
        }
    }

    public static Ason toAson(String json) {
        Object jsonObj = JsonSerializer.deserialize(json);
        return (Ason)jsonObj;
    }

    public static <T> T formJson(String json, Class<T> cls) {
        Object jsonObj = JsonSerializer.deserialize(json);
        return BeanSerializer.deserialize(cls, jsonObj);
    }
}

