/*
 * Decompiled with CFR 0.152.
 */
package com.blade.mvc.handler;

import com.blade.Blade;
import com.blade.exception.BladeException;
import com.blade.exception.InternalErrorException;
import com.blade.ioc.Ioc;
import com.blade.kit.BladeKit;
import com.blade.kit.ReflectKit;
import com.blade.mvc.annotation.JSON;
import com.blade.mvc.annotation.Path;
import com.blade.mvc.handler.RouteHandler;
import com.blade.mvc.hook.Signature;
import com.blade.mvc.hook.WebHook;
import com.blade.mvc.http.Response;
import com.blade.mvc.route.Route;
import com.blade.mvc.ui.ModelAndView;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class RequestInvoker {
    private final Blade blade;
    private final Ioc ioc;

    public RequestInvoker(Blade blade) {
        this.blade = blade;
        this.ioc = blade.ioc();
    }

    public void routeHandle(Signature signature) throws Exception {
        Object target = signature.getRoute().getTarget();
        if (null == target) {
            Class<?> clazz = signature.getAction().getDeclaringClass();
            target = this.blade.getBean(clazz);
            signature.getRoute().setTarget(target);
        }
        if (signature.getRoute().getTargetType() == RouteHandler.class) {
            RouteHandler routeHandler = (RouteHandler)target;
            routeHandler.handle(signature.request(), signature.response());
        } else {
            this.handle(signature);
        }
    }

    public void handle(Signature signature) throws Exception {
        try {
            int len;
            Object returnParam;
            boolean isRestful;
            Method actionMethod = signature.getAction();
            Object target = signature.getRoute().getTarget();
            Class<?> returnType = actionMethod.getReturnType();
            Response response = signature.response();
            Path path = target.getClass().getAnnotation(Path.class);
            JSON JSON2 = actionMethod.getAnnotation(JSON.class);
            boolean bl = isRestful = null != JSON2 || null != path && path.restful();
            if (isRestful && !signature.request().userAgent().contains("MSIE")) {
                signature.response().contentType("application/json; charset=UTF-8");
            }
            if (null == (returnParam = ReflectKit.invokeMethod(target, actionMethod, (len = actionMethod.getParameterTypes().length) > 0 ? signature.getParameters() : null))) {
                return;
            }
            if (isRestful) {
                response.json(returnParam);
                return;
            }
            if (returnType == String.class) {
                response.render(returnParam.toString());
                return;
            }
            if (returnType == ModelAndView.class) {
                ModelAndView modelAndView = (ModelAndView)returnParam;
                response.render(modelAndView);
            }
        }
        catch (Exception e) {
            if (e instanceof InvocationTargetException) {
                e = (Exception)e.getCause();
            }
            throw e;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean invokeHook(Signature routeSignature, Route hookRoute) throws Exception {
        Object returnParam;
        Method hookMethod = hookRoute.getAction();
        Object target = hookRoute.getTarget();
        if (null == target) {
            Class<?> clazz = hookRoute.getAction().getDeclaringClass();
            target = this.ioc.getBean(clazz);
            hookRoute.setTarget(target);
        }
        int len = hookMethod.getParameterTypes().length;
        hookMethod.setAccessible(true);
        if (len > 0) {
            if (len == 1) {
                returnParam = ReflectKit.invokeMethod(target, hookMethod, routeSignature);
            } else {
                if (len != 2) throw new InternalErrorException("Bad web hook structure");
                returnParam = ReflectKit.invokeMethod(target, hookMethod, routeSignature.request(), routeSignature.response());
            }
        } else {
            returnParam = ReflectKit.invokeMethod(target, hookMethod, new Object[0]);
        }
        if (null == returnParam) {
            return true;
        }
        Class<?> returnType = returnParam.getClass();
        if (returnType != Boolean.class && returnType != Boolean.TYPE) return true;
        return Boolean.valueOf(returnParam.toString());
    }

    public boolean invokeMiddleware(List<Route> middleware, Signature signature) throws BladeException {
        if (BladeKit.isEmpty(middleware)) {
            return true;
        }
        for (Route route : middleware) {
            WebHook webHook = (WebHook)route.getTarget();
            boolean flag = webHook.before(signature);
            if (flag) continue;
            return false;
        }
        return true;
    }

    public boolean invokeHook(List<Route> hooks, Signature signature) throws Exception {
        for (Route hook : hooks) {
            if (hook.getTargetType() == RouteHandler.class) {
                RouteHandler routeHandler = (RouteHandler)hook.getTarget();
                routeHandler.handle(signature.request(), signature.response());
                continue;
            }
            boolean flag = this.invokeHook(signature, hook);
            if (flag) continue;
            return false;
        }
        return true;
    }
}

